/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.perf.instance.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.perf.instance.dao.ApiPerfInstanceDao;
import io.tiklab.teston.test.apix.http.perf.instance.entity.ApiPerfInstanceEntity;
import io.tiklab.teston.test.apix.http.perf.instance.model.ApiPerfInstance;
import io.tiklab.teston.test.apix.http.perf.instance.model.ApiPerfInstanceQuery;
import io.tiklab.teston.test.apix.http.perf.instance.service.ApiPerfInstanceService;
import java.sql.Timestamp;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiPerfInstanceServiceImpl
implements ApiPerfInstanceService {
    @Autowired
    ApiPerfInstanceDao apiPerfInstanceDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createApiPerfInstance(@NotNull @Valid ApiPerfInstance perfInstance) {
        ApiPerfInstanceEntity perfInstanceEntity = (ApiPerfInstanceEntity)BeanMapper.map((Object)perfInstance, ApiPerfInstanceEntity.class);
        perfInstanceEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.apiPerfInstanceDao.createApiPerfInstance(perfInstanceEntity);
    }

    public void updateApiPerfInstance(@NotNull @Valid ApiPerfInstance perfInstance) {
        ApiPerfInstanceEntity perfInstanceEntity = (ApiPerfInstanceEntity)BeanMapper.map((Object)perfInstance, ApiPerfInstanceEntity.class);
        this.apiPerfInstanceDao.updateApiPerfInstance(perfInstanceEntity);
    }

    public void deleteApiPerfInstance(@NotNull String id) {
        this.apiPerfInstanceDao.deleteApiPerfInstance(id);
    }

    public ApiPerfInstance findOne(String id) {
        ApiPerfInstanceEntity perfInstanceEntity = this.apiPerfInstanceDao.findApiPerfInstance(id);
        ApiPerfInstance perfInstance = (ApiPerfInstance)BeanMapper.map((Object)perfInstanceEntity, ApiPerfInstance.class);
        return perfInstance;
    }

    public List<ApiPerfInstance> findList(List<String> idList) {
        List<ApiPerfInstanceEntity> perfInstanceEntities = this.apiPerfInstanceDao.findApiPerfInstanceList(idList);
        List perfInstanceList = BeanMapper.mapList(perfInstanceEntities, ApiPerfInstance.class);
        return perfInstanceList;
    }

    public ApiPerfInstance findApiPerfInstance(@NotNull String id) {
        ApiPerfInstance perfInstance = this.findOne(id);
        this.joinTemplate.joinQuery((Object)perfInstance);
        return perfInstance;
    }

    public List<ApiPerfInstance> findAllApiPerfInstance() {
        List<ApiPerfInstanceEntity> perfInstanceEntities = this.apiPerfInstanceDao.findAllApiPerfInstance();
        List perfInstanceList = BeanMapper.mapList(perfInstanceEntities, ApiPerfInstance.class);
        this.joinTemplate.joinQuery(perfInstanceList);
        return perfInstanceList;
    }

    public List<ApiPerfInstance> findApiPerfInstanceList(ApiPerfInstanceQuery performanceInstanceQuery) {
        List<ApiPerfInstanceEntity> perfInstanceEntities = this.apiPerfInstanceDao.findApiPerfInstanceList(performanceInstanceQuery);
        List perfInstanceList = BeanMapper.mapList(perfInstanceEntities, ApiPerfInstance.class);
        this.joinTemplate.joinQuery(perfInstanceList);
        return perfInstanceList;
    }

    public Pagination<ApiPerfInstance> findApiPerfInstancePage(ApiPerfInstanceQuery performanceInstanceQuery) {
        Pagination<ApiPerfInstanceEntity> pagination = this.apiPerfInstanceDao.findApiPerfInstancePage(performanceInstanceQuery);
        List perfInstanceList = BeanMapper.mapList((List)pagination.getDataList(), ApiPerfInstance.class);
        this.joinTemplate.joinQuery(perfInstanceList);
        return PaginationBuilder.build(pagination, (List)perfInstanceList);
    }
}

