/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.perf.execute.service;

import io.tiklab.rpc.client.router.lookup.FixedLookup;
import io.tiklab.rpc.client.router.lookup.Lookup;
import io.tiklab.teston.agent.api.http.perf.ApiPerfTestService;
import io.tiklab.teston.support.agentconfig.model.AgentConfig;
import io.tiklab.teston.support.agentconfig.model.AgentConfigQuery;
import io.tiklab.teston.support.agentconfig.service.AgentConfigService;
import io.tiklab.teston.support.utils.RpcClientApixUtil;
import io.tiklab.teston.support.utils.TestApixUtil;
import io.tiklab.teston.test.apix.http.perf.cases.model.ApiPerfCase;
import io.tiklab.teston.test.apix.http.perf.cases.model.ApiPerfStep;
import io.tiklab.teston.test.apix.http.perf.cases.model.ApiPerfStepQuery;
import io.tiklab.teston.test.apix.http.perf.cases.service.ApiPerfCaseService;
import io.tiklab.teston.test.apix.http.perf.cases.service.ApiPerfStepService;
import io.tiklab.teston.test.apix.http.perf.execute.model.ApiPerfTestRequest;
import io.tiklab.teston.test.apix.http.perf.execute.model.ApiPerfTestResponse;
import io.tiklab.teston.test.apix.http.perf.execute.service.ApiPerfExecuteDispatchService;
import io.tiklab.teston.test.apix.http.perf.instance.model.ApiPerfInstance;
import io.tiklab.teston.test.apix.http.perf.instance.model.ApiPerfInstanceQuery;
import io.tiklab.teston.test.apix.http.perf.instance.service.ApiPerfInstanceService;
import io.tiklab.teston.test.apix.http.scene.cases.model.ApiSceneCase;
import io.tiklab.teston.test.apix.http.scene.execute.model.ApiSceneTestRequest;
import io.tiklab.teston.test.apix.http.scene.execute.service.ApiSceneExecuteDispatchService;
import io.tiklab.teston.test.apix.http.scene.instance.model.ApiSceneInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApiPerfExecuteDispatchServiceImpl
implements ApiPerfExecuteDispatchService {
    public static final Logger logger = LoggerFactory.getLogger(ApiPerfExecuteDispatchServiceImpl.class);
    @Autowired
    ApiPerfCaseService apiPerfCaseService;
    @Autowired
    ApiPerfStepService apiPerfStepService;
    @Autowired
    ApiPerfInstanceService apiPerfInstanceService;
    @Autowired
    ApiSceneExecuteDispatchService apiSceneExecuteDispatchService;
    @Autowired
    AgentConfigService agentConfigService;
    @Autowired
    RpcClientApixUtil rpcClientApixUtil;
    @Autowired
    TestApixUtil testApixUtil;
    @Autowired
    ApiPerfTestService apiPerfTestService;
    @Value(value="${teston-agent.embbed.enable:false}")
    Boolean enable;
    private List<AgentConfig> agentConfigList;
    private Integer executeCount;
    public Integer status = 0;
    private String apiPerfInstanceId;

    ApiPerfTestService apiPerfTestServiceRPC(String agentUrl) {
        return (ApiPerfTestService)this.rpcClientApixUtil.rpcClient().getBean(ApiPerfTestService.class, (Lookup)new FixedLookup(agentUrl));
    }

    public void execute(ApiPerfTestRequest apiPerfTestRequest) {
        this.status = 1;
        this.apiPerfInstanceId = null;
        String apiPerfId = apiPerfTestRequest.getApiPerfCase().getId();
        ApiPerfCase apiPerfCase = this.apiPerfCaseService.findApiPerfCase(apiPerfId);
        List<ApiSceneTestRequest> apiSceneTestRequestList = this.processApiPerfTestData(apiPerfTestRequest);
        apiPerfTestRequest.setApiPerfCase(apiPerfCase);
        apiPerfTestRequest.setApiSceneTestRequestList(apiSceneTestRequestList);
        this.executeCount = apiPerfCase.getExecuteCount();
        this.agentConfigList = this.agentConfigService.findAgentConfigList(new AgentConfigQuery());
        int agentSize = this.agentConfigList.size();
        Integer executeType = apiPerfCase.getExecuteType();
        List<Object> distributionList = new ArrayList();
        if (executeType == 1) {
            distributionList = this.testApixUtil.loop(this.executeCount, agentSize);
        }
        if (executeType == 2) {
            distributionList = this.testApixUtil.random(this.executeCount, agentSize);
        }
        for (int i = 0; i < agentSize; ++i) {
            apiPerfTestRequest.setExeNum((Integer)distributionList.get(i));
            AgentConfig agentConfig = this.agentConfigList.get(i);
            String agentUrl = agentConfig.getUrl();
            if (this.enable.booleanValue()) {
                this.apiPerfTestService.execute(apiPerfTestRequest);
                continue;
            }
            this.apiPerfTestServiceRPC(agentUrl).execute(apiPerfTestRequest);
        }
    }

    public ApiPerfTestResponse exeResult(ApiPerfTestRequest apiPerfTestRequest) {
        ApiPerfTestResponse apiPerfTestResponse = new ApiPerfTestResponse();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.agentConfigList.size(); ++i) {
            ApiPerfTestResponse response = null;
            response = this.enable != false ? this.apiPerfTestService.exeResult() : this.apiPerfTestServiceRPC(this.agentConfigList.get(i).getUrl()).exeResult();
            if (!CollectionUtils.isNotEmpty((Collection)response.getApiSceneInstanceList())) continue;
            arrayList.addAll(response.getApiSceneInstanceList());
        }
        apiPerfTestResponse.setApiSceneInstanceList(arrayList);
        this.status = apiPerfTestResponse.getApiSceneInstanceList().size() == this.executeCount.intValue() ? Integer.valueOf(2) : Integer.valueOf(1);
        apiPerfTestResponse.setStatus(this.status);
        ApiPerfInstance apiPerfInstance = this.processPerfTestData(apiPerfTestResponse);
        apiPerfTestResponse.setApiPerfInstance(apiPerfInstance);
        if (apiPerfTestRequest.getExeType() == null) {
            String apiPerfId = apiPerfTestRequest.getApiPerfCase().getId();
            apiPerfInstance.setApiPerfId(apiPerfId);
            if (this.apiPerfInstanceId == null) {
                ApiPerfInstanceQuery apiPerfInstanceQuery = new ApiPerfInstanceQuery();
                apiPerfInstanceQuery.setApiPerfId(apiPerfId);
                List apiPerfInstanceList = this.apiPerfInstanceService.findApiPerfInstanceList(apiPerfInstanceQuery);
                if (apiPerfInstanceList != null && apiPerfInstanceList.size() > 0) {
                    Integer executeNumber = ((ApiPerfInstance)apiPerfInstanceList.get(0)).getExecuteNumber();
                    executeNumber = executeNumber + 1;
                    apiPerfInstance.setExecuteNumber(executeNumber);
                } else {
                    apiPerfInstance.setExecuteNumber(Integer.valueOf(1));
                }
                this.apiPerfInstanceId = this.apiPerfInstanceService.createApiPerfInstance(apiPerfInstance);
            } else {
                apiPerfInstance.setId(this.apiPerfInstanceId);
                this.apiPerfInstanceService.updateApiPerfInstance(apiPerfInstance);
            }
        }
        return apiPerfTestResponse;
    }

    private List<ApiSceneTestRequest> processApiPerfTestData(ApiPerfTestRequest apiPerfTestRequest) {
        String apiPerfId = apiPerfTestRequest.getApiPerfCase().getId();
        ApiPerfStepQuery apiPerfStepQuery = new ApiPerfStepQuery();
        apiPerfStepQuery.setApiPerfId(apiPerfId);
        List apiPerfStepList = this.apiPerfStepService.findApiPerfStepList(apiPerfStepQuery);
        ArrayList<ApiSceneTestRequest> apiSceneTestRequestList = new ArrayList<ApiSceneTestRequest>();
        if (CollectionUtils.isNotEmpty((Collection)apiPerfStepList)) {
            for (ApiPerfStep apiPerfStep : apiPerfStepList) {
                ApiSceneTestRequest apiSceneTestRequest = new ApiSceneTestRequest();
                ApiSceneCase apiSceneCase = new ApiSceneCase();
                apiSceneCase.setId(apiPerfStep.getApiScene().getId());
                apiSceneTestRequest.setApiSceneCase(apiSceneCase);
                apiSceneTestRequest.setApiEnv(apiPerfTestRequest.getApiEnv());
                List apiUnitTestRequestList = this.apiSceneExecuteDispatchService.processApiSceneTestData(apiSceneTestRequest);
                apiSceneTestRequest.setApiUnitTestRequestList(apiUnitTestRequestList);
                apiSceneTestRequestList.add(apiSceneTestRequest);
            }
        }
        return apiSceneTestRequestList;
    }

    private ApiPerfInstance processPerfTestData(ApiPerfTestResponse apiPerfTestResponse) {
        ApiPerfInstance apiPerfInstance = new ApiPerfInstance();
        int size = apiPerfTestResponse.getApiSceneInstanceList().size();
        apiPerfInstance.setTotal(Integer.valueOf(size));
        int passCount = 0;
        for (ApiSceneInstance apiSceneInstance : apiPerfTestResponse.getApiSceneInstanceList()) {
            if (!apiSceneInstance.getResult().equals(1)) continue;
            ++passCount;
        }
        String passRate = this.testApixUtil.processRate(passCount, size);
        apiPerfInstance.setPassRate(passRate);
        apiPerfInstance.setPassNum(Integer.valueOf(passCount));
        apiPerfInstance.setFailNum(Integer.valueOf(size - passCount));
        String errorRate = this.testApixUtil.processRate(size - passCount, size);
        apiPerfInstance.setErrorRate(errorRate);
        if (size == passCount) {
            apiPerfInstance.setResult(Integer.valueOf(1));
        } else {
            apiPerfInstance.setResult(Integer.valueOf(0));
        }
        return apiPerfInstance;
    }

    public void stop(ApiPerfTestRequest apiPerfTestRequest) {
    }
}

