/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.perf.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.perf.cases.dao.ApiPerfStepDao;
import io.tiklab.teston.test.apix.http.perf.cases.entity.ApiPerfStepEntity;
import io.tiklab.teston.test.apix.http.perf.cases.model.ApiPerfStep;
import io.tiklab.teston.test.apix.http.perf.cases.model.ApiPerfStepQuery;
import io.tiklab.teston.test.apix.http.perf.cases.service.ApiPerfStepService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.service.TestCaseService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiPerfStepServiceImpl
implements ApiPerfStepService {
    @Autowired
    ApiPerfStepDao apiPerfStepDao;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    JoinTemplate joinTemplate;

    public String createApiPerfStep(@NotNull @Valid ApiPerfStep apiPerfStep) {
        ApiPerfStepEntity apiPerfStepEntity = (ApiPerfStepEntity)BeanMapper.map((Object)apiPerfStep, ApiPerfStepEntity.class);
        apiPerfStepEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.apiPerfStepDao.createApiPerfStep(apiPerfStepEntity);
    }

    public void updateApiPerfStep(@NotNull @Valid ApiPerfStep apiPerfStep) {
        ApiPerfStepEntity apiPerfStepEntity = (ApiPerfStepEntity)BeanMapper.map((Object)apiPerfStep, ApiPerfStepEntity.class);
        this.apiPerfStepDao.updateApiPerfStep(apiPerfStepEntity);
    }

    public void deleteApiPerfStep(@NotNull String id) {
        this.apiPerfStepDao.deleteApiPerfStep(id);
    }

    public ApiPerfStep findOne(String id) {
        ApiPerfStepEntity apiPerfStepEntity = this.apiPerfStepDao.findApiPerfStep(id);
        ApiPerfStep apiPerfStep = (ApiPerfStep)BeanMapper.map((Object)apiPerfStepEntity, ApiPerfStep.class);
        return apiPerfStep;
    }

    public List<ApiPerfStep> findList(List<String> idList) {
        List<ApiPerfStepEntity> apiPerfStepEntityList = this.apiPerfStepDao.findApiPerfStepList(idList);
        List apiPerfStepList = BeanMapper.mapList(apiPerfStepEntityList, ApiPerfStep.class);
        return apiPerfStepList;
    }

    public ApiPerfStep findApiPerfStep(@NotNull String id) {
        ApiPerfStep apiPerfStep = this.findOne(id);
        this.joinTemplate.joinQuery((Object)apiPerfStep);
        return apiPerfStep;
    }

    public List<ApiPerfStep> findAllApiPerfStep() {
        List<ApiPerfStepEntity> apiPerfStepEntityList = this.apiPerfStepDao.findAllApiPerfStep();
        List apiPerfStepList = BeanMapper.mapList(apiPerfStepEntityList, ApiPerfStep.class);
        this.joinTemplate.joinQuery(apiPerfStepList);
        return apiPerfStepList;
    }

    public List<ApiPerfStep> findApiPerfStepList(ApiPerfStepQuery apiPerfStepQuery) {
        List<ApiPerfStepEntity> apiPerfStepEntityList = this.apiPerfStepDao.findApiPerfStepList(apiPerfStepQuery);
        List apiPerfStepList = BeanMapper.mapList(apiPerfStepEntityList, ApiPerfStep.class);
        this.joinTemplate.joinQuery(apiPerfStepList);
        ArrayList<ApiPerfStep> arrayList = new ArrayList<ApiPerfStep>();
        if (apiPerfStepList.size() > 0) {
            for (ApiPerfStep apiPerfStep : apiPerfStepList) {
                TestCase testCase = this.testCaseService.findTestCase(apiPerfStep.getApiScene().getId());
                apiPerfStep.getApiScene().setTestCase(testCase);
                arrayList.add(apiPerfStep);
            }
        }
        return arrayList;
    }

    public Pagination<ApiPerfStep> findApiPerfStepPage(ApiPerfStepQuery apiPerfStepQuery) {
        Pagination<ApiPerfStepEntity> pagination = this.apiPerfStepDao.findApiPerfStepPage(apiPerfStepQuery);
        List apiPerfStepList = BeanMapper.mapList((List)pagination.getDataList(), ApiPerfStep.class);
        this.joinTemplate.joinQuery(apiPerfStepList);
        return PaginationBuilder.build(pagination, (List)apiPerfStepList);
    }

    public void bindApiScene(List<ApiPerfStep> apiSceneStepList) {
        for (ApiPerfStep apiPerfStep : apiSceneStepList) {
            this.createApiPerfStep(apiPerfStep);
        }
    }
}

