/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.perf.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.category.model.Category;
import io.tiklab.teston.category.service.CategoryService;
import io.tiklab.teston.test.apix.http.perf.cases.dao.ApiPerfCaseDao;
import io.tiklab.teston.test.apix.http.perf.cases.entity.ApiPerfCaseEntity;
import io.tiklab.teston.test.apix.http.perf.cases.model.ApiPerfCase;
import io.tiklab.teston.test.apix.http.perf.cases.model.ApiPerfCaseQuery;
import io.tiklab.teston.test.apix.http.perf.cases.service.ApiPerfCaseService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import io.tiklab.teston.test.test.service.TestCaseService;
import io.tiklab.user.user.model.User;
import io.tiklab.user.user.service.UserService;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ApiPerfCaseServiceImpl
implements ApiPerfCaseService {
    @Autowired
    ApiPerfCaseDao apiPerfCaseDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    CategoryService categoryService;
    @Autowired
    UserService userService;

    public String createApiPerfCase(@NotNull @Valid ApiPerfCase apiPerfCase) {
        ApiPerfCaseEntity apiPerfCaseEntity = (ApiPerfCaseEntity)BeanMapper.map((Object)apiPerfCase, ApiPerfCaseEntity.class);
        apiPerfCaseEntity.setExecuteCount(1);
        apiPerfCaseEntity.setThreadCount(1);
        apiPerfCaseEntity.setExecuteType(1);
        String id = this.apiPerfCaseDao.createApiPerfCase(apiPerfCaseEntity);
        apiPerfCaseEntity.setTestCaseId(id);
        apiPerfCaseEntity.setId(id);
        this.apiPerfCaseDao.updateApiPerfCase(apiPerfCaseEntity);
        TestCase testCase = apiPerfCase.getTestCase();
        testCase.setId(id);
        this.testCaseService.createTestCase(testCase);
        return id;
    }

    public void updateApiPerfCase(@NotNull @Valid ApiPerfCase apiPerfCase) {
        ApiPerfCaseEntity apiPerfCaseEntity = (ApiPerfCaseEntity)BeanMapper.map((Object)apiPerfCase, ApiPerfCaseEntity.class);
        this.apiPerfCaseDao.updateApiPerfCase(apiPerfCaseEntity);
        this.testCaseService.updateTestCase(apiPerfCase.getTestCase());
    }

    public void deleteApiPerfCase(@NotNull String id) {
        this.apiPerfCaseDao.deleteApiPerfCase(id);
    }

    public ApiPerfCase findOne(String id) {
        ApiPerfCaseEntity apiPerfCaseEntity = this.apiPerfCaseDao.findApiPerfCase(id);
        ApiPerfCase apiPerfCase = (ApiPerfCase)BeanMapper.map((Object)apiPerfCaseEntity, ApiPerfCase.class);
        return apiPerfCase;
    }

    public List<ApiPerfCase> findList(List<String> idList) {
        List<ApiPerfCaseEntity> apiPerfCaseEntityList = this.apiPerfCaseDao.findApiPerfCaseList(idList);
        List apiPerfCaseList = BeanMapper.mapList(apiPerfCaseEntityList, ApiPerfCase.class);
        return apiPerfCaseList;
    }

    public ApiPerfCase findApiPerfCase(@NotNull String id) {
        ApiPerfCase apiPerfCase = this.findOne(id);
        this.joinTemplate.joinQuery((Object)apiPerfCase);
        TestCase testCase = apiPerfCase.getTestCase();
        if (testCase.getCategory() != null) {
            Category category = this.categoryService.findCategory(testCase.getCategory().getId());
            apiPerfCase.getTestCase().setCategory(category);
        }
        if (testCase.getUpdateUser() != null) {
            User updateUser = this.userService.findUser(testCase.getUpdateUser().getId());
            apiPerfCase.getTestCase().setUpdateUser(updateUser);
        }
        return apiPerfCase;
    }

    public List<ApiPerfCase> findAllApiPerfCase() {
        List<ApiPerfCaseEntity> apiPerfCaseEntityList = this.apiPerfCaseDao.findAllApiPerfCase();
        List apiPerfCaseList = BeanMapper.mapList(apiPerfCaseEntityList, ApiPerfCase.class);
        this.joinTemplate.joinQuery(apiPerfCaseList);
        return apiPerfCaseList;
    }

    public List<ApiPerfCase> findApiPerfCaseList(ApiPerfCaseQuery apiPerfCaseQuery) {
        List<ApiPerfCaseEntity> apiPerfCaseEntityList = this.apiPerfCaseDao.findApiPerfCaseList(apiPerfCaseQuery);
        List apiPerfCaseList = BeanMapper.mapList(apiPerfCaseEntityList, ApiPerfCase.class);
        this.joinTemplate.joinQuery(apiPerfCaseList);
        return apiPerfCaseList;
    }

    public Pagination<ApiPerfCase> findApiPerfCasePage(ApiPerfCaseQuery apiPerfCaseQuery) {
        Pagination<ApiPerfCaseEntity> pagination = this.apiPerfCaseDao.findApiPerfCasePage(apiPerfCaseQuery);
        List apiPerfCaseList = BeanMapper.mapList((List)pagination.getDataList(), ApiPerfCase.class);
        this.joinTemplate.joinQuery(apiPerfCaseList);
        return PaginationBuilder.build(pagination, (List)apiPerfCaseList);
    }

    public List<ApiPerfCase> findApiPerfCaseListByTestCase(TestCaseQuery testCaseQuery) {
        List testCaseList = this.testCaseService.findTestCaseList(testCaseQuery);
        ArrayList<ApiPerfCase> apiPerfList = new ArrayList<ApiPerfCase>();
        if (!ObjectUtils.isEmpty((Object)testCaseList)) {
            for (TestCase testCase : testCaseList) {
                List<ApiPerfCase> apiPerfCaseList = this.findApiPerfCaseList(new ApiPerfCaseQuery().setTestCaseId(testCase.getId()));
                if (ObjectUtils.isEmpty(apiPerfCaseList)) continue;
                apiPerfList.add(apiPerfCaseList.get(0));
            }
        }
        return apiPerfList;
    }
}

