/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.support.environment.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.rpc.annotation.Exporter;
import io.tiklab.teston.support.environment.dao.WebEnvDao;
import io.tiklab.teston.support.environment.entity.WebEnvEntity;
import io.tiklab.teston.support.environment.model.WebEnv;
import io.tiklab.teston.support.environment.model.WebEnvQuery;
import io.tiklab.teston.support.environment.service.WebEnvService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Exporter
public class WebEnvServiceImpl
implements WebEnvService {
    @Autowired
    WebEnvDao webEnvDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createWebEnv(@NotNull @Valid WebEnv webEnv) {
        WebEnvEntity webEnvEntity = (WebEnvEntity)BeanMapper.map((Object)webEnv, WebEnvEntity.class);
        return this.webEnvDao.createWebEnv(webEnvEntity);
    }

    public void updateWebEnv(@NotNull @Valid WebEnv webEnv) {
        WebEnvEntity webEnvEntity = (WebEnvEntity)BeanMapper.map((Object)webEnv, WebEnvEntity.class);
        this.webEnvDao.updateWebEnv(webEnvEntity);
    }

    public void deleteWebEnv(@NotNull String id) {
        this.webEnvDao.deleteWebEnv(id);
    }

    public WebEnv findOne(String id) {
        WebEnvEntity webEnvEntity = this.webEnvDao.findWebEnv(id);
        WebEnv webEnv = (WebEnv)BeanMapper.map((Object)webEnvEntity, WebEnv.class);
        return webEnv;
    }

    public List<WebEnv> findList(List<String> idList) {
        List<WebEnvEntity> webEnvEntityList = this.webEnvDao.findWebEnvList(idList);
        List webEnvList = BeanMapper.mapList(webEnvEntityList, WebEnv.class);
        return webEnvList;
    }

    public WebEnv findWebEnv(@NotNull String id) {
        WebEnv webEnv = this.findOne(id);
        this.joinTemplate.joinQuery((Object)webEnv);
        return webEnv;
    }

    public List<WebEnv> findAllWebEnv() {
        List<WebEnvEntity> webEnvEntityList = this.webEnvDao.findAllWebEnv();
        List webEnvList = BeanMapper.mapList(webEnvEntityList, WebEnv.class);
        this.joinTemplate.joinQuery(webEnvList);
        return webEnvList;
    }

    public List<WebEnv> findWebEnvList(WebEnvQuery webEnvQuery) {
        List<WebEnvEntity> webEnvEntityList = this.webEnvDao.findWebEnvList(webEnvQuery);
        List webEnvList = BeanMapper.mapList(webEnvEntityList, WebEnv.class);
        this.joinTemplate.joinQuery(webEnvList);
        return webEnvList;
    }

    public Pagination<WebEnv> findWebEnvPage(WebEnvQuery webEnvQuery) {
        Pagination<WebEnvEntity> pagination = this.webEnvDao.findWebEnvPage(webEnvQuery);
        List webEnvList = BeanMapper.mapList((List)pagination.getDataList(), WebEnv.class);
        this.joinTemplate.joinQuery(webEnvList);
        return PaginationBuilder.build(pagination, (List)webEnvList);
    }
}

