/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.support.environment.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.rpc.annotation.Exporter;
import io.tiklab.teston.support.environment.dao.AppEnvDao;
import io.tiklab.teston.support.environment.entity.AppEnvEntity;
import io.tiklab.teston.support.environment.model.AppEnv;
import io.tiklab.teston.support.environment.model.AppEnvQuery;
import io.tiklab.teston.support.environment.service.AppEnvService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Exporter
public class AppEnvServiceImpl
implements AppEnvService {
    @Autowired
    AppEnvDao appEnvDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createAppEnv(@NotNull @Valid AppEnv appEnv) {
        AppEnvEntity appEnvEntity = (AppEnvEntity)BeanMapper.map((Object)appEnv, AppEnvEntity.class);
        return this.appEnvDao.createAppEnv(appEnvEntity);
    }

    public void updateAppEnv(@NotNull @Valid AppEnv appEnv) {
        AppEnvEntity appEnvEntity = (AppEnvEntity)BeanMapper.map((Object)appEnv, AppEnvEntity.class);
        this.appEnvDao.updateAppEnv(appEnvEntity);
    }

    public void deleteAppEnv(@NotNull String id) {
        this.appEnvDao.deleteAppEnv(id);
    }

    public AppEnv findOne(String id) {
        AppEnvEntity appEnvEntity = this.appEnvDao.findAppEnv(id);
        AppEnv appEnv = (AppEnv)BeanMapper.map((Object)appEnvEntity, AppEnv.class);
        return appEnv;
    }

    public List<AppEnv> findList(List<String> idList) {
        List<AppEnvEntity> appEnvEntityList = this.appEnvDao.findAppEnvList(idList);
        List appEnvList = BeanMapper.mapList(appEnvEntityList, AppEnv.class);
        return appEnvList;
    }

    public AppEnv findAppEnv(@NotNull String id) {
        AppEnv appEnv = this.findOne(id);
        this.joinTemplate.joinQuery((Object)appEnv);
        return appEnv;
    }

    public List<AppEnv> findAllAppEnv() {
        List<AppEnvEntity> appEnvEntityList = this.appEnvDao.findAllAppEnv();
        List appEnvList = BeanMapper.mapList(appEnvEntityList, AppEnv.class);
        this.joinTemplate.joinQuery(appEnvList);
        return appEnvList;
    }

    public List<AppEnv> findAppEnvList(AppEnvQuery appEnvQuery) {
        List<AppEnvEntity> appEnvEntityList = this.appEnvDao.findAppEnvList(appEnvQuery);
        List appEnvList = BeanMapper.mapList(appEnvEntityList, AppEnv.class);
        this.joinTemplate.joinQuery(appEnvList);
        return appEnvList;
    }

    public Pagination<AppEnv> findAppEnvPage(AppEnvQuery appEnvQuery) {
        Pagination<AppEnvEntity> pagination = this.appEnvDao.findAppEnvPage(appEnvQuery);
        List appEnvList = BeanMapper.mapList((List)pagination.getDataList(), AppEnv.class);
        this.joinTemplate.joinQuery(appEnvList);
        return PaginationBuilder.build(pagination, (List)appEnvList);
    }
}

