/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.support.environment.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.rpc.annotation.Exporter;
import io.tiklab.teston.support.environment.dao.ApiEnvDao;
import io.tiklab.teston.support.environment.entity.ApiEnvEntity;
import io.tiklab.teston.support.environment.model.ApiEnv;
import io.tiklab.teston.support.environment.model.ApiEnvQuery;
import io.tiklab.teston.support.environment.service.ApiEnvService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Exporter
public class ApiEnvServiceImpl
implements ApiEnvService {
    @Autowired
    ApiEnvDao apiEnvDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createApiEnv(@NotNull @Valid ApiEnv apiEnv) {
        ApiEnvEntity apiEnvEntity = (ApiEnvEntity)BeanMapper.map((Object)apiEnv, ApiEnvEntity.class);
        return this.apiEnvDao.createApiEnv(apiEnvEntity);
    }

    public void updateApiEnv(@NotNull @Valid ApiEnv apiEnv) {
        ApiEnvEntity apiEnvEntity = (ApiEnvEntity)BeanMapper.map((Object)apiEnv, ApiEnvEntity.class);
        this.apiEnvDao.updateApiEnv(apiEnvEntity);
    }

    public void deleteApiEnv(@NotNull String id) {
        this.apiEnvDao.deleteApiEnv(id);
    }

    public ApiEnv findOne(String id) {
        ApiEnvEntity apiEnvEntity = this.apiEnvDao.findApiEnv(id);
        ApiEnv apiEnv = (ApiEnv)BeanMapper.map((Object)apiEnvEntity, ApiEnv.class);
        return apiEnv;
    }

    public List<ApiEnv> findList(List<String> idList) {
        List<ApiEnvEntity> apiEnvEntityList = this.apiEnvDao.findApiEnvList(idList);
        List apiEnvList = BeanMapper.mapList(apiEnvEntityList, ApiEnv.class);
        return apiEnvList;
    }

    public ApiEnv findApiEnv(@NotNull String id) {
        ApiEnv apiEnv = this.findOne(id);
        this.joinTemplate.joinQuery((Object)apiEnv);
        return apiEnv;
    }

    public List<ApiEnv> findAllApiEnv() {
        List<ApiEnvEntity> apiEnvEntityList = this.apiEnvDao.findAllApiEnv();
        List apiEnvList = BeanMapper.mapList(apiEnvEntityList, ApiEnv.class);
        this.joinTemplate.joinQuery(apiEnvList);
        return apiEnvList;
    }

    public List<ApiEnv> findApiEnvList(ApiEnvQuery apiEnvQuery) {
        List<ApiEnvEntity> apiEnvEntityList = this.apiEnvDao.findApiEnvList(apiEnvQuery);
        List apiEnvList = BeanMapper.mapList(apiEnvEntityList, ApiEnv.class);
        this.joinTemplate.joinQuery(apiEnvList);
        return apiEnvList;
    }

    public Pagination<ApiEnv> findApiEnvPage(ApiEnvQuery apiEnvQuery) {
        Pagination<ApiEnvEntity> pagination = this.apiEnvDao.findApiEnvPage(apiEnvQuery);
        List apiEnvList = BeanMapper.mapList((List)pagination.getDataList(), ApiEnv.class);
        this.joinTemplate.joinQuery(apiEnvList);
        return PaginationBuilder.build(pagination, (List)apiEnvList);
    }
}

