/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.support.environment.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.teston.support.environment.entity.WebEnvEntity;
import io.tiklab.teston.support.environment.model.WebEnvQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebEnvDao {
    private static Logger logger = LoggerFactory.getLogger(WebEnvDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createWebEnv(WebEnvEntity webEnvEntity) {
        return (String)this.jpaTemplate.save((Object)webEnvEntity, String.class);
    }

    public void updateWebEnv(WebEnvEntity webEnvEntity) {
        this.jpaTemplate.update((Object)webEnvEntity);
    }

    public void deleteWebEnv(String id) {
        this.jpaTemplate.delete(WebEnvEntity.class, (Object)id);
    }

    public void deleteWebEnv(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public WebEnvEntity findWebEnv(String id) {
        return (WebEnvEntity)this.jpaTemplate.findOne(WebEnvEntity.class, (Object)id);
    }

    public List<WebEnvEntity> findAllWebEnv() {
        return this.jpaTemplate.findAll(WebEnvEntity.class);
    }

    public List<WebEnvEntity> findWebEnvList(List<String> idList) {
        return this.jpaTemplate.findList(WebEnvEntity.class, idList);
    }

    public List<WebEnvEntity> findWebEnvList(WebEnvQuery webEnvQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(WebEnvEntity.class).eq("repositoryId", (Object)webEnvQuery.getRepositoryId()).orders(webEnvQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, WebEnvEntity.class);
    }

    public Pagination<WebEnvEntity> findWebEnvPage(WebEnvQuery webEnvQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(WebEnvEntity.class).eq("repositoryId", (Object)webEnvQuery.getRepositoryId()).orders(webEnvQuery.getOrderParams()).pagination(webEnvQuery.getPageParam()).get();
        return this.jpaTemplate.findPage(queryCondition, WebEnvEntity.class);
    }
}

