/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.support.environment.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.support.environment.model.WebEnv;
import io.tiklab.teston.support.environment.model.WebEnvQuery;
import io.tiklab.teston.support.environment.service.WebEnvService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/webEnv"})
@Api(name="WebEnvController", desc="Web\u73af\u5883\u7ba1\u7406")
public class WebEnvController {
    private static Logger logger = LoggerFactory.getLogger(WebEnvController.class);
    @Autowired
    private WebEnvService webEnvService;

    @RequestMapping(path={"/createWebEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="createWebEnv", desc="\u521b\u5efaWeb\u73af\u5883")
    @ApiParam(name="webEnv", desc="webEnv", required=true)
    public Result<String> createWebEnv(@RequestBody @NotNull @Valid WebEnv webEnv) {
        String id = this.webEnvService.createWebEnv(webEnv);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateWebEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="updateWebEnv", desc="\u66f4\u65b0Web\u73af\u5883")
    @ApiParam(name="webEnv", desc="webEnv", required=true)
    public Result<Void> updateWebEnv(@RequestBody @NotNull @Valid WebEnv webEnv) {
        this.webEnvService.updateWebEnv(webEnv);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteWebEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteWebEnv", desc="\u5220\u9664Web\u73af\u5883")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteWebEnv(@NotNull String id) {
        this.webEnvService.deleteWebEnv(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findWebEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="findWebEnv", desc="\u6839\u636eid\u67e5\u627eWeb\u73af\u5883")
    @ApiParam(name="id", desc="id", required=true)
    public Result<WebEnv> findWebEnv(@NotNull String id) {
        WebEnv webEnv = this.webEnvService.findWebEnv(id);
        return Result.ok((Object)webEnv);
    }

    @RequestMapping(path={"/findAllWebEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllWebEnv", desc="\u67e5\u627e\u6240\u6709Web\u73af\u5883")
    public Result<List<WebEnv>> findAllWebEnv() {
        List webEnvList = this.webEnvService.findAllWebEnv();
        return Result.ok((Object)webEnvList);
    }

    @RequestMapping(path={"/findWebEnvList"}, method={RequestMethod.POST})
    @ApiMethod(name="findWebEnvList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2Web\u73af\u5883\u5217\u8868")
    @ApiParam(name="webEnvQuery", desc="webEnvQuery", required=true)
    public Result<List<WebEnv>> findWebEnvList(@RequestBody @Valid @NotNull WebEnvQuery webEnvQuery) {
        List webEnvList = this.webEnvService.findWebEnvList(webEnvQuery);
        return Result.ok((Object)webEnvList);
    }

    @RequestMapping(path={"/findWebEnvPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findWebEnvPage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2Web\u73af\u5883")
    @ApiParam(name="webEnvQuery", desc="webEnvQuery", required=true)
    public Result<Pagination<WebEnv>> findWebEnvPage(@RequestBody @Valid @NotNull WebEnvQuery webEnvQuery) {
        Pagination pagination = this.webEnvService.findWebEnvPage(webEnvQuery);
        return Result.ok((Object)pagination);
    }
}

