/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.support.environment.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.support.environment.model.AppEnv;
import io.tiklab.teston.support.environment.model.AppEnvQuery;
import io.tiklab.teston.support.environment.service.AppEnvService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/appEnv"})
@Api(name="AppEnvController", desc="app\u73af\u5883\u7ba1\u7406")
public class AppEnvController {
    private static Logger logger = LoggerFactory.getLogger(AppEnvController.class);
    @Autowired
    private AppEnvService appEnvService;

    @RequestMapping(path={"/createAppEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="createAppEnv", desc="\u521b\u5efaapp\u73af\u5883")
    @ApiParam(name="appEnv", desc="appEnv", required=true)
    public Result<String> createAppEnv(@RequestBody @NotNull @Valid AppEnv appEnv) {
        String id = this.appEnvService.createAppEnv(appEnv);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateAppEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="updateAppEnv", desc="\u66f4\u65b0app\u73af\u5883")
    @ApiParam(name="appEnv", desc="appEnv", required=true)
    public Result<Void> updateAppEnv(@RequestBody @NotNull @Valid AppEnv appEnv) {
        this.appEnvService.updateAppEnv(appEnv);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteAppEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteAppEnv", desc="\u5220\u9664app\u73af\u5883")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteAppEnv(@NotNull String id) {
        this.appEnvService.deleteAppEnv(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findAppEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="findAppEnv", desc="\u6839\u636eid\u67e5\u627eapp\u73af\u5883")
    @ApiParam(name="id", desc="id", required=true)
    public Result<AppEnv> findAppEnv(@NotNull String id) {
        AppEnv appEnv = this.appEnvService.findAppEnv(id);
        return Result.ok((Object)appEnv);
    }

    @RequestMapping(path={"/findAllAppEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllAppEnv", desc="\u67e5\u627e\u6240\u6709app\u73af\u5883")
    public Result<List<AppEnv>> findAllAppEnv() {
        List appEnvList = this.appEnvService.findAllAppEnv();
        return Result.ok((Object)appEnvList);
    }

    @RequestMapping(path={"/findAppEnvList"}, method={RequestMethod.POST})
    @ApiMethod(name="findAppEnvList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2app\u73af\u5883\u5217\u8868")
    @ApiParam(name="appEnvQuery", desc="appEnvQuery", required=true)
    public Result<List<AppEnv>> findAppEnvList(@RequestBody @Valid @NotNull AppEnvQuery appEnvQuery) {
        List appEnvList = this.appEnvService.findAppEnvList(appEnvQuery);
        return Result.ok((Object)appEnvList);
    }

    @RequestMapping(path={"/findAppEnvPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findAppEnvPage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2app\u73af\u5883")
    @ApiParam(name="appEnvQuery", desc="appEnvQuery", required=true)
    public Result<Pagination<AppEnv>> findAppEnvPage(@RequestBody @Valid @NotNull AppEnvQuery appEnvQuery) {
        Pagination pagination = this.appEnvService.findAppEnvPage(appEnvQuery);
        return Result.ok((Object)pagination);
    }
}

