/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.support.environment.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.support.environment.model.ApiEnv;
import io.tiklab.teston.support.environment.model.ApiEnvQuery;
import io.tiklab.teston.support.environment.service.ApiEnvService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/apiEnv"})
@Api(name="ApiEnvController", desc="\u6d4b\u8bd5\u73af\u5883\u7ba1\u7406")
public class ApiEnvController {
    private static Logger logger = LoggerFactory.getLogger(ApiEnvController.class);
    @Autowired
    private ApiEnvService apiEnvService;

    @RequestMapping(path={"/createApiEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="createApiEnv", desc="\u6dfb\u52a0\u6d4b\u8bd5\u73af\u5883")
    @ApiParam(name="apiEnv", desc="apiEnv", required=true)
    public Result<String> createApiEnv(@RequestBody @NotNull @Valid ApiEnv apiEnv) {
        String id = this.apiEnvService.createApiEnv(apiEnv);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateApiEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="updateApiEnv", desc="\u66f4\u65b0\u6d4b\u8bd5\u73af\u5883")
    @ApiParam(name="apiEnv", desc="apiEnv", required=true)
    public Result<Void> updateApiEnv(@RequestBody @NotNull @Valid ApiEnv apiEnv) {
        this.apiEnvService.updateApiEnv(apiEnv);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteApiEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteApiEnv", desc="\u5220\u9664\u6d4b\u8bd5\u73af\u5883")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteApiEnv(@NotNull String id) {
        this.apiEnvService.deleteApiEnv(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findApiEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="findApiEnv", desc="\u901a\u8fc7id\u67e5\u8be2\u6d4b\u8bd5\u73af\u5883")
    @ApiParam(name="id", desc="id", required=true)
    public Result<ApiEnv> findApiEnv(@NotNull String id) {
        ApiEnv apiEnv = this.apiEnvService.findApiEnv(id);
        return Result.ok((Object)apiEnv);
    }

    @RequestMapping(path={"/findAllApiEnv"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllApiEnv", desc="\u67e5\u8be2\u6240\u6709\u6d4b\u8bd5\u73af\u5883")
    public Result<List<ApiEnv>> findAllApiEnv() {
        List apiEnvList = this.apiEnvService.findAllApiEnv();
        return Result.ok((Object)apiEnvList);
    }

    @RequestMapping(path={"/findApiEnvList"}, method={RequestMethod.POST})
    @ApiMethod(name="findApiEnvList", desc="\u901a\u8fc7\u67e5\u8be2\u5bf9\u8c61\u67e5\u8be2\u6d4b\u8bd5\u73af\u5883")
    @ApiParam(name="apiEnvQuery", desc="apiEnvQuery", required=true)
    public Result<List<ApiEnv>> findApiEnvList(@RequestBody @Valid @NotNull ApiEnvQuery apiEnvQuery) {
        List apiEnvList = this.apiEnvService.findApiEnvList(apiEnvQuery);
        return Result.ok((Object)apiEnvList);
    }

    @RequestMapping(path={"/findApiEnvPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findApiEnvPage", desc="\u901a\u8fc7\u67e5\u8be2\u5bf9\u8c61\u5206\u9875\u67e5\u8be2\u6d4b\u8bd5\u73af\u5883")
    @ApiParam(name="apiEnvQuery", desc="apiEnvQuery", required=true)
    public Result<Pagination<ApiEnv>> findApiEnvPage(@RequestBody @Valid @NotNull ApiEnvQuery apiEnvQuery) {
        Pagination pagination = this.apiEnvService.findApiEnvPage(apiEnvQuery);
        return Result.ok((Object)pagination);
    }
}

