/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.support.agentconfig.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.support.agentconfig.dao.AgentConfigDao;
import io.tiklab.teston.support.agentconfig.entity.AgentConfigEntity;
import io.tiklab.teston.support.agentconfig.model.AgentConfig;
import io.tiklab.teston.support.agentconfig.model.AgentConfigQuery;
import io.tiklab.teston.support.agentconfig.service.AgentConfigService;
import java.sql.Timestamp;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgentConfigServiceImpl
implements AgentConfigService {
    @Autowired
    AgentConfigDao agentConfigDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createAgentConfig(@NotNull @Valid AgentConfig agentConfig) {
        AgentConfigEntity agentConfigEntity = (AgentConfigEntity)BeanMapper.map((Object)agentConfig, AgentConfigEntity.class);
        agentConfigEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.agentConfigDao.createAgentConfig(agentConfigEntity);
    }

    public void updateAgentConfig(@NotNull @Valid AgentConfig agentConfig) {
        AgentConfigEntity agentConfigEntity = (AgentConfigEntity)BeanMapper.map((Object)agentConfig, AgentConfigEntity.class);
        this.agentConfigDao.updateAgentConfig(agentConfigEntity);
    }

    public void deleteAgentConfig(@NotNull String id) {
        this.agentConfigDao.deleteAgentConfig(id);
    }

    public AgentConfig findOne(String id) {
        AgentConfigEntity agentConfigEntity = this.agentConfigDao.findAgentConfig(id);
        AgentConfig agentConfig = (AgentConfig)BeanMapper.map((Object)agentConfigEntity, AgentConfig.class);
        return agentConfig;
    }

    public List<AgentConfig> findList(List<String> idList) {
        List<AgentConfigEntity> agentConfigEntityList = this.agentConfigDao.findAgentConfigList(idList);
        List agentConfigList = BeanMapper.mapList(agentConfigEntityList, AgentConfig.class);
        return agentConfigList;
    }

    public AgentConfig findAgentConfig(@NotNull String id) {
        AgentConfig agentConfig = this.findOne(id);
        this.joinTemplate.joinQuery((Object)agentConfig);
        return agentConfig;
    }

    public List<AgentConfig> findAllAgentConfig() {
        List<AgentConfigEntity> agentConfigEntityList = this.agentConfigDao.findAllAgentConfig();
        List agentConfigList = BeanMapper.mapList(agentConfigEntityList, AgentConfig.class);
        this.joinTemplate.joinQuery(agentConfigList);
        return agentConfigList;
    }

    public List<AgentConfig> findAgentConfigList(AgentConfigQuery agentConfigQuery) {
        List<AgentConfigEntity> agentConfigEntityList = this.agentConfigDao.findAgentConfigList(agentConfigQuery);
        List agentConfigList = BeanMapper.mapList(agentConfigEntityList, AgentConfig.class);
        this.joinTemplate.joinQuery(agentConfigList);
        return agentConfigList;
    }

    public Pagination<AgentConfig> findAgentConfigPage(AgentConfigQuery agentConfigQuery) {
        Pagination<AgentConfigEntity> pagination = this.agentConfigDao.findAgentConfigPage(agentConfigQuery);
        List agentConfigList = BeanMapper.mapList((List)pagination.getDataList(), AgentConfig.class);
        this.joinTemplate.joinQuery(agentConfigList);
        return PaginationBuilder.build(pagination, (List)agentConfigList);
    }
}

