/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.support.agentconfig.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.support.agentconfig.model.AgentConfig;
import io.tiklab.teston.support.agentconfig.model.AgentConfigQuery;
import io.tiklab.teston.support.agentconfig.service.AgentConfigService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/agentConfig"})
@Api(name="AgentConfigController", desc="agent\u914d\u7f6e \u7ba1\u7406")
public class AgentConfigController {
    private static Logger logger = LoggerFactory.getLogger(AgentConfigController.class);
    @Autowired
    private AgentConfigService agentConfigService;

    @RequestMapping(path={"/createAgentConfig"}, method={RequestMethod.POST})
    @ApiMethod(name="createAgentConfig", desc="\u521b\u5efaagent\u914d\u7f6e")
    @ApiParam(name="agentConfig", desc="agentConfig", required=true)
    public Result<String> createAgentConfig(@RequestBody @NotNull @Valid AgentConfig agentConfig) {
        String id = this.agentConfigService.createAgentConfig(agentConfig);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateAgentConfig"}, method={RequestMethod.POST})
    @ApiMethod(name="updateAgentConfig", desc="\u66f4\u65b0agent\u914d\u7f6e")
    @ApiParam(name="agentConfig", desc="agentConfig", required=true)
    public Result<Void> updateAgentConfig(@RequestBody @NotNull @Valid AgentConfig agentConfig) {
        this.agentConfigService.updateAgentConfig(agentConfig);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteAgentConfig"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteAgentConfig", desc="\u5220\u9664agent\u914d\u7f6e")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteAgentConfig(@NotNull String id) {
        this.agentConfigService.deleteAgentConfig(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findAgentConfig"}, method={RequestMethod.POST})
    @ApiMethod(name="findAgentConfig", desc="\u6839\u636eid\u67e5\u627eagent\u914d\u7f6e")
    @ApiParam(name="id", desc="id", required=true)
    public Result<AgentConfig> findAgentConfig(@NotNull String id) {
        AgentConfig agentConfig = this.agentConfigService.findAgentConfig(id);
        return Result.ok((Object)agentConfig);
    }

    @RequestMapping(path={"/findAllAgentConfig"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllAgentConfig", desc="\u67e5\u627e\u6240\u6709agent\u914d\u7f6e")
    public Result<List<AgentConfig>> findAllAgentConfig() {
        List agentConfigList = this.agentConfigService.findAllAgentConfig();
        return Result.ok((Object)agentConfigList);
    }

    @RequestMapping(path={"/findAgentConfigList"}, method={RequestMethod.POST})
    @ApiMethod(name="findAgentConfigList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2agent\u914d\u7f6e\u5217\u8868")
    @ApiParam(name="agentConfigQuery", desc="agentConfigQuery", required=true)
    public Result<List<AgentConfig>> findAgentConfigList(@RequestBody @Valid @NotNull AgentConfigQuery agentConfigQuery) {
        List agentConfigList = this.agentConfigService.findAgentConfigList(agentConfigQuery);
        return Result.ok((Object)agentConfigList);
    }

    @RequestMapping(path={"/findAgentConfigPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findAgentConfigPage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2agent\u914d\u7f6e")
    @ApiParam(name="agentConfigQuery", desc="agentConfigQuery", required=true)
    public Result<Pagination<AgentConfig>> findAgentConfigPage(@RequestBody @Valid @NotNull AgentConfigQuery agentConfigQuery) {
        Pagination pagination = this.agentConfigService.findAgentConfigPage(agentConfigQuery);
        return Result.ok((Object)pagination);
    }
}

