/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.support.actiontype.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.support.actiontype.dao.ActionTypeDao;
import io.tiklab.teston.support.actiontype.entity.ActionTypeEntity;
import io.tiklab.teston.support.actiontype.model.ActionType;
import io.tiklab.teston.support.actiontype.model.ActionTypeQuery;
import io.tiklab.teston.support.actiontype.service.ActionTypeService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActionTypeServiceImpl
implements ActionTypeService {
    @Autowired
    ActionTypeDao actionTypeDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createActionType(@NotNull @Valid ActionType actionType) {
        ActionTypeEntity actionTypeEntity = (ActionTypeEntity)BeanMapper.map((Object)actionType, ActionTypeEntity.class);
        return this.actionTypeDao.createActionType(actionTypeEntity);
    }

    public void updateActionType(@NotNull @Valid ActionType actionType) {
        ActionTypeEntity actionTypeEntity = (ActionTypeEntity)BeanMapper.map((Object)actionType, ActionTypeEntity.class);
        this.actionTypeDao.updateActionType(actionTypeEntity);
    }

    public void deleteActionType(@NotNull String id) {
        this.actionTypeDao.deleteActionType(id);
    }

    public ActionType findOne(String id) {
        ActionTypeEntity actionTypeEntity = this.actionTypeDao.findActionType(id);
        ActionType actionType = (ActionType)BeanMapper.map((Object)actionTypeEntity, ActionType.class);
        return actionType;
    }

    public List<ActionType> findList(List<String> idList) {
        List<ActionTypeEntity> actionTypeEntityList = this.actionTypeDao.findActionTypeList(idList);
        List actionTypeList = BeanMapper.mapList(actionTypeEntityList, ActionType.class);
        return actionTypeList;
    }

    public ActionType findActionType(@NotNull String id) {
        ActionType actionType = this.findOne(id);
        this.joinTemplate.joinQuery((Object)actionType);
        return actionType;
    }

    public List<ActionType> findAllActionType() {
        List<ActionTypeEntity> actionTypeEntityList = this.actionTypeDao.findAllActionType();
        List actionTypeList = BeanMapper.mapList(actionTypeEntityList, ActionType.class);
        this.joinTemplate.joinQuery(actionTypeList);
        return actionTypeList;
    }

    public List<ActionType> findActionTypeList(ActionTypeQuery actionTypeQuery) {
        List<ActionTypeEntity> actionTypeEntityList = this.actionTypeDao.findActionTypeList(actionTypeQuery);
        List actionTypeList = BeanMapper.mapList(actionTypeEntityList, ActionType.class);
        this.joinTemplate.joinQuery(actionTypeList);
        return actionTypeList;
    }

    public Pagination<ActionType> findActionTypePage(ActionTypeQuery actionTypeQuery) {
        Pagination<ActionTypeEntity> pagination = this.actionTypeDao.findActionTypePage(actionTypeQuery);
        List actionTypeList = BeanMapper.mapList((List)pagination.getDataList(), ActionType.class);
        this.joinTemplate.joinQuery(actionTypeList);
        return PaginationBuilder.build(pagination, (List)actionTypeList);
    }
}

