/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.support.actiontype.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.support.actiontype.model.ActionType;
import io.tiklab.teston.support.actiontype.model.ActionTypeQuery;
import io.tiklab.teston.support.actiontype.service.ActionTypeService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/actionType"})
@Api(name="ActionTypeController", desc="\u6d4b\u8bd5\u6b65\u9aa4\u64cd\u4f5c\u65b9\u6cd5\u7684\u8bcd\u9879\u5b57\u5178\u7ba1\u7406")
public class ActionTypeController {
    private static Logger logger = LoggerFactory.getLogger(ActionTypeController.class);
    @Autowired
    private ActionTypeService actionTypeService;

    @RequestMapping(path={"/createActionType"}, method={RequestMethod.POST})
    @ApiMethod(name="createActionType", desc="\u521b\u5efa\u64cd\u4f5c\u7c7b\u578b")
    @ApiParam(name="actionType", desc="actionType", required=true)
    public Result<String> createActionType(@RequestBody @NotNull @Valid ActionType actionType) {
        String id = this.actionTypeService.createActionType(actionType);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateActionType"}, method={RequestMethod.POST})
    @ApiMethod(name="updateActionType", desc="\u66f4\u65b0\u64cd\u4f5c\u7c7b\u578b")
    @ApiParam(name="actionType", desc="actionType", required=true)
    public Result<Void> updateActionType(@RequestBody @NotNull @Valid ActionType actionType) {
        this.actionTypeService.updateActionType(actionType);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteActionType"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteActionType", desc="\u5220\u9664\u64cd\u4f5c\u7c7b\u578b")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteActionType(@NotNull String id) {
        this.actionTypeService.deleteActionType(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findActionType"}, method={RequestMethod.POST})
    @ApiMethod(name="findActionType", desc="\u6839\u636eid\u67e5\u627e\u64cd\u4f5c\u7c7b\u578b")
    @ApiParam(name="id", desc="id", required=true)
    public Result<ActionType> findActionType(@NotNull String id) {
        ActionType actionType = this.actionTypeService.findActionType(id);
        return Result.ok((Object)actionType);
    }

    @RequestMapping(path={"/findAllActionType"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllActionType", desc="\u67e5\u8be2\u6240\u6709\u6d4b\u8bd5\u6b65\u9aa4\u64cd\u4f5c\u65b9\u6cd5\u7684\u8bcd\u9879\u5b57\u5178")
    public Result<List<ActionType>> findAllActionType() {
        List actionTypeList = this.actionTypeService.findAllActionType();
        return Result.ok((Object)actionTypeList);
    }

    @RequestMapping(path={"/findActionTypeList"}, method={RequestMethod.POST})
    @ApiMethod(name="findActionTypeList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2\u64cd\u4f5c\u7c7b\u578b\u5217\u8868")
    @ApiParam(name="actionTypeQuery", desc="actionTypeQuery", required=true)
    public Result<List<ActionType>> findActionTypeList(@RequestBody @Valid @NotNull ActionTypeQuery actionTypeQuery) {
        List actionTypeList = this.actionTypeService.findActionTypeList(actionTypeQuery);
        return Result.ok((Object)actionTypeList);
    }

    @RequestMapping(path={"/findActionTypePage"}, method={RequestMethod.POST})
    @ApiMethod(name="findActionTypePage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2\u64cd\u4f5c\u7c7b\u578b")
    @ApiParam(name="actionTypeQuery", desc="actionTypeQuery", required=true)
    public Result<Pagination<ActionType>> findActionTypePage(@RequestBody @Valid @NotNull ActionTypeQuery actionTypeQuery) {
        Pagination pagination = this.actionTypeService.findActionTypePage(actionTypeQuery);
        return Result.ok((Object)pagination);
    }
}

