/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.repository.service;

import com.alibaba.fastjson.JSONObject;
import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.eam.common.context.LoginContext;
import io.tiklab.join.JoinTemplate;
import io.tiklab.message.message.model.SendMessageNotice;
import io.tiklab.message.message.service.SendMessageNoticeService;
import io.tiklab.privilege.dmRole.service.DmRoleService;
import io.tiklab.rpc.annotation.Exporter;
import io.tiklab.security.logging.model.LoggingType;
import io.tiklab.security.logging.service.LoggingTypeService;
import io.tiklab.teston.category.model.Category;
import io.tiklab.teston.category.model.CategoryQuery;
import io.tiklab.teston.category.service.CategoryService;
import io.tiklab.teston.common.LogUnit;
import io.tiklab.teston.common.TestOnUnit;
import io.tiklab.teston.repository.dao.RepositoryDao;
import io.tiklab.teston.repository.entity.RepositoryEntity;
import io.tiklab.teston.repository.model.Repository;
import io.tiklab.teston.repository.model.RepositoryFollowQuery;
import io.tiklab.teston.repository.model.RepositoryQuery;
import io.tiklab.teston.repository.model.RepositoryRecent;
import io.tiklab.teston.repository.model.RepositoryRecentQuery;
import io.tiklab.teston.repository.service.RepositoryFollowService;
import io.tiklab.teston.repository.service.RepositoryRecentService;
import io.tiklab.teston.repository.service.RepositoryService;
import io.tiklab.teston.testplan.cases.service.TestPlanService;
import io.tiklab.user.dmUser.model.DmUser;
import io.tiklab.user.dmUser.model.DmUserQuery;
import io.tiklab.user.dmUser.service.DmUserService;
import io.tiklab.user.user.model.User;
import io.tiklab.user.user.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Exporter
public class RepositoryServiceImpl
implements RepositoryService {
    @Autowired
    RepositoryDao repositoryDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    CategoryService categoryService;
    @Autowired
    DmUserService dmUserService;
    @Autowired
    RepositoryFollowService repositoryFollowService;
    @Autowired
    RepositoryRecentService repositoryRecentService;
    @Autowired
    UserService userService;
    @Autowired
    DmRoleService dmRoleService;
    @Autowired
    TestOnUnit testOnUnit;
    @Autowired
    LoggingTypeService loggingTypeService;
    @Autowired
    SendMessageNoticeService sendMessageNoticeService;
    @Autowired
    LogUnit logUnit;
    @Autowired
    TestPlanService testPlanService;
    @Value(value="${base.url:null}")
    String baseUrl;

    public String createRepository(@NotNull @Valid Repository repository) {
        String userId = LoginContext.getLoginId();
        User userInfo = this.userService.findUser(userId);
        RepositoryEntity repositoryEntity = (RepositoryEntity)BeanMapper.map((Object)repository, RepositoryEntity.class);
        repositoryEntity.setUserId(userId);
        String repositoryId = this.repositoryDao.createRepository(repositoryEntity);
        Category category = new Category();
        Repository rep = new Repository();
        rep.setId(repositoryId);
        category.setRepository(rep);
        category.setName("\u9ed8\u8ba4\u5206\u7ec4");
        this.categoryService.createCategory(category);
        this.dmRoleService.initPatchDmRole(repositoryId, repository.getUserList(), "teston");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", repository.getName());
        map.put("repositoryId", repositoryId);
        map.put("user", this.testOnUnit.getUser().getNickname());
        map.put("mode", "\u4ed3\u5e93");
        map.put("images", repository.getIconUrl());
        LoggingType oplogTypeOne = this.loggingTypeService.findOplogTypeOne("CREATE_TYPE");
        map.put("actionType", oplogTypeOne.getName());
        this.logUnit.log("CREATE_TYPE", "repository", map);
        SendMessageNotice messageDispatchNotice = new SendMessageNotice();
        HashMap<String, String> site_mail_Map = new HashMap<String, String>();
        site_mail_Map.put("name", repository.getName());
        site_mail_Map.put("id", repositoryId);
        site_mail_Map.put("userName", userInfo.getNickname());
        site_mail_Map.put("images", repository.getIconUrl());
        String siteMailMsg = JSONObject.toJSONString(site_mail_Map);
        messageDispatchNotice.setSiteData(siteMailMsg);
        messageDispatchNotice.setEmailData(siteMailMsg);
        HashMap<String, String> DD_MSGMap = new HashMap<String, String>();
        DD_MSGMap.put("name", repository.getName());
        DD_MSGMap.put("userName", userInfo.getNickname());
        DD_MSGMap.put("images", repository.getIconUrl());
        messageDispatchNotice.setDingdingData(JSONObject.toJSONString(DD_MSGMap));
        HashMap<String, String> WX_MSGMap = new HashMap<String, String>();
        WX_MSGMap.put("name", repository.getName());
        WX_MSGMap.put("userName", userInfo.getNickname());
        messageDispatchNotice.setQywechatData(JSONObject.toJSONString(WX_MSGMap));
        messageDispatchNotice.setId("MESSAGE_NOTICE_ID");
        messageDispatchNotice.setBaseUrl(this.baseUrl);
        this.sendMessageNoticeService.createMessageItem(messageDispatchNotice);
        return repositoryId;
    }

    public void updateRepository(@NotNull @Valid Repository repository) {
        RepositoryEntity repositoryEntity = (RepositoryEntity)BeanMapper.map((Object)repository, RepositoryEntity.class);
        this.repositoryDao.updateRepository(repositoryEntity);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", repository.getName());
        map.put("repositoryId", repository.getId());
        map.put("user", this.testOnUnit.getUser().getNickname());
        map.put("mode", "\u4ed3\u5e93");
        map.put("images", repository.getIconUrl());
        LoggingType oplogTypeOne = this.loggingTypeService.findOplogTypeOne("UPDATE_TYPE");
        map.put("actionType", oplogTypeOne.getName());
        this.logUnit.log("UPDATE_TYPE", "repository", map);
    }

    public void deleteRepository(@NotNull String id) {
        this.repositoryDao.deleteRepository(id);
        List categoryList = this.categoryService.findCategoryList(new CategoryQuery().setRepositoryId(id));
        if (CollectionUtils.isNotEmpty((Collection)categoryList)) {
            for (Category category : categoryList) {
                this.categoryService.deleteCategory(category.getId());
            }
        }
        String loginId = LoginContext.getLoginId();
        RepositoryFollowQuery repositoryFollowQuery = new RepositoryFollowQuery();
        repositoryFollowQuery.setUserId(loginId);
        List repositoryFollowList = this.repositoryFollowService.findRepositoryFollowList(repositoryFollowQuery);
        if (CollectionUtils.isNotEmpty((Collection)repositoryFollowList)) {
            for (Repository repositoryFollow : repositoryFollowList) {
                if (!Objects.equals(repositoryFollow.getId(), id)) continue;
                this.repositoryFollowService.deleteRepositoryFollow(repositoryFollow.getId());
            }
        }
        RepositoryRecentQuery repositoryRecentQuery = new RepositoryRecentQuery();
        repositoryRecentQuery.setUserId(loginId);
        List recentList = this.repositoryRecentService.findRecentList(repositoryRecentQuery);
        if (CollectionUtils.isNotEmpty((Collection)recentList)) {
            for (RepositoryRecent repositoryRecent : recentList) {
                if (!Objects.equals(repositoryRecent.getRepository().getId(), id)) continue;
                this.repositoryRecentService.deleteRepositoryRecent(repositoryRecent.getId());
            }
        }
        this.dmRoleService.deleteDmRoleByDomainId(id);
    }

    public Repository findOne(String id) {
        RepositoryEntity repositoryEntity = this.repositoryDao.findRepository(id);
        Repository repository = (Repository)BeanMapper.map((Object)repositoryEntity, Repository.class);
        return repository;
    }

    public List<Repository> findList(List<String> idList) {
        List<RepositoryEntity> repositoryEntityList = this.repositoryDao.findRepositoryList(idList);
        List repositoryList = BeanMapper.mapList(repositoryEntityList, Repository.class);
        return repositoryList;
    }

    public Repository findRepository(@NotNull String id) {
        Repository repository = this.findOne(id);
        this.joinTemplate.joinQuery((Object)repository);
        return repository;
    }

    public List<Repository> findAllRepository() {
        List<RepositoryEntity> repositoryEntityList = this.repositoryDao.findAllRepository();
        List repositoryList = BeanMapper.mapList(repositoryEntityList, Repository.class);
        this.joinTemplate.joinQuery(repositoryList);
        return repositoryList;
    }

    public List<Repository> findRepositoryList(RepositoryQuery repositoryQuery) {
        List<RepositoryEntity> repositoryEntityList = this.repositoryDao.findRepositoryList(repositoryQuery);
        List repositoryList = BeanMapper.mapList(repositoryEntityList, Repository.class);
        RepositoryFollowQuery repositoryFollowQuery = new RepositoryFollowQuery();
        List repositoryFollowList = this.repositoryFollowService.findRepositoryFollowList(repositoryFollowQuery);
        if (CollectionUtils.isNotEmpty((Collection)repositoryList) && CollectionUtils.isNotEmpty((Collection)repositoryFollowList)) {
            for (Repository repository : repositoryList) {
                for (Repository repositoryFollow : repositoryFollowList) {
                    if (Objects.equals(repository.getId(), repositoryFollow.getId())) {
                        repository.setIsFollow(Integer.valueOf(1));
                        continue;
                    }
                    repository.setIsFollow(Integer.valueOf(0));
                }
            }
        } else {
            for (Repository repository : repositoryList) {
                repository.setIsFollow(Integer.valueOf(0));
            }
        }
        this.joinTemplate.joinQuery(repositoryList);
        return repositoryList;
    }

    public Pagination<Repository> findRepositoryPage(RepositoryQuery repositoryQuery) {
        Pagination<RepositoryEntity> pagination = this.repositoryDao.findRepositoryPage(repositoryQuery);
        List repositoryList = BeanMapper.mapList((List)pagination.getDataList(), Repository.class);
        this.joinTemplate.joinQuery(repositoryList);
        return PaginationBuilder.build(pagination, (List)repositoryList);
    }

    public List<Repository> findRepositoryJoinList(RepositoryQuery repositoryQuery) {
        RepositoryQuery processQuery = new RepositoryQuery();
        processQuery.setOrderParams(repositoryQuery.getOrderParams());
        List<Repository> repositoryList = this.findRepositoryList(processQuery);
        ArrayList<Repository> repositoryArrayList = new ArrayList<Repository>();
        String userId = repositoryQuery.getUserId();
        for (Repository repository : repositoryList) {
            DmUserQuery dmUserQuery = new DmUserQuery();
            dmUserQuery.setUserId(userId);
            dmUserQuery.setDomainId(repository.getId());
            List dmUserList = this.dmUserService.findDmUserList(dmUserQuery);
            if (dmUserList == null || dmUserList.size() == 0) continue;
            for (DmUser dmUser : dmUserList) {
                if (!Objects.equals(dmUser.getUser().getId(), userId)) continue;
                repositoryArrayList.add(repository);
            }
        }
        this.joinTemplate.joinQuery(repositoryArrayList);
        return repositoryArrayList;
    }
}

