/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.repository.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.repository.dao.RepositoryRecentDao;
import io.tiklab.teston.repository.entity.RepositoryRecentEntity;
import io.tiklab.teston.repository.model.Repository;
import io.tiklab.teston.repository.model.RepositoryRecent;
import io.tiklab.teston.repository.model.RepositoryRecentQuery;
import io.tiklab.teston.repository.service.RepositoryRecentService;
import io.tiklab.teston.repository.service.RepositoryService;
import io.tiklab.teston.testplan.cases.model.TestPlanQuery;
import io.tiklab.teston.testplan.cases.service.TestPlanService;
import io.tiklab.user.dmUser.model.DmUserQuery;
import io.tiklab.user.dmUser.service.DmUserService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RepositoryRecentServiceImpl
implements RepositoryRecentService {
    @Autowired
    RepositoryRecentDao repositoryRecentDao;
    @Autowired
    RepositoryService repositoryService;
    @Autowired
    TestPlanService testPlanService;
    @Autowired
    DmUserService dmUserService;
    @Autowired
    JoinTemplate joinTemplate;

    public String createRepositoryRecent(@NotNull @Valid RepositoryRecent repositoryRecent) {
        RepositoryRecentEntity repositoryRecentEntity = (RepositoryRecentEntity)BeanMapper.map((Object)repositoryRecent, RepositoryRecentEntity.class);
        return this.repositoryRecentDao.createRepositoryRecent(repositoryRecentEntity);
    }

    public void updateRepositoryRecent(@NotNull @Valid RepositoryRecent repositoryRecent) {
        RepositoryRecentEntity repositoryRecentEntity = (RepositoryRecentEntity)BeanMapper.map((Object)repositoryRecent, RepositoryRecentEntity.class);
        this.repositoryRecentDao.updateRepositoryRecent(repositoryRecentEntity);
    }

    public void deleteRepositoryRecent(@NotNull String id) {
        this.repositoryRecentDao.deleteRepositoryRecent(id);
    }

    public RepositoryRecent findOne(String id) {
        RepositoryRecentEntity repositoryRecentEntity = this.repositoryRecentDao.findRepositoryRecent(id);
        RepositoryRecent repositoryRecent = (RepositoryRecent)BeanMapper.map((Object)repositoryRecentEntity, RepositoryRecent.class);
        return repositoryRecent;
    }

    public List<RepositoryRecent> findList(List<String> idList) {
        List<RepositoryRecentEntity> repositoryRecentEntityList = this.repositoryRecentDao.findRepositoryRecentList(idList);
        List repositoryRecentList = BeanMapper.mapList(repositoryRecentEntityList, RepositoryRecent.class);
        return repositoryRecentList;
    }

    public RepositoryRecent findRepositoryRecent(@NotNull String id) {
        RepositoryRecent repositoryRecent = this.findOne(id);
        this.joinTemplate.joinQuery((Object)repositoryRecent);
        return repositoryRecent;
    }

    public List<RepositoryRecent> findAllRepositoryRecent() {
        List<RepositoryRecentEntity> repositoryRecentEntityList = this.repositoryRecentDao.findAllRepositoryRecent();
        List repositoryRecentList = BeanMapper.mapList(repositoryRecentEntityList, RepositoryRecent.class);
        this.joinTemplate.joinQuery(repositoryRecentList);
        return repositoryRecentList;
    }

    public List<Repository> findRepositoryRecentList(RepositoryRecentQuery repositoryRecentQuery) {
        List<RepositoryRecentEntity> repositoryRecentEntityList = this.repositoryRecentDao.findRepositoryRecentList(repositoryRecentQuery);
        List repositoryRecentList = BeanMapper.mapList(repositoryRecentEntityList, RepositoryRecent.class);
        ArrayList<Repository> repList = new ArrayList<Repository>();
        for (RepositoryRecent repositoryRecent : repositoryRecentList) {
            String repositoryId = repositoryRecent.getRepository().getId();
            Repository repository = this.repositoryService.findRepository(repositoryId);
            int planNum = 0;
            List testPlanList = this.testPlanService.findTestPlanList(new TestPlanQuery().setRepositoryId(repositoryId));
            planNum = testPlanList.size();
            repository.setPlanNum(Integer.valueOf(planNum));
            int memberNum = 0;
            DmUserQuery dmUserQuery = new DmUserQuery();
            dmUserQuery.setDomainId(repositoryId);
            List dmUserList = this.dmUserService.findDmUserList(dmUserQuery);
            memberNum = dmUserList.size();
            repository.setMemberNum(Integer.valueOf(memberNum));
            repList.add(repository);
        }
        this.joinTemplate.joinQuery(repList);
        return repList;
    }

    public List<RepositoryRecent> findRecentList(RepositoryRecentQuery repositoryRecentQuery) {
        List<RepositoryRecentEntity> repositoryRecentEntityList = this.repositoryRecentDao.findRepositoryRecentList(repositoryRecentQuery);
        List repositoryRecentList = BeanMapper.mapList(repositoryRecentEntityList, RepositoryRecent.class);
        this.joinTemplate.joinQuery(repositoryRecentList);
        return repositoryRecentList;
    }

    public Pagination<RepositoryRecent> findRepositoryRecentPage(RepositoryRecentQuery repositoryRecentQuery) {
        Pagination<RepositoryRecentEntity> pagination = this.repositoryRecentDao.findRepositoryRecentPage(repositoryRecentQuery);
        List repositoryRecentList = BeanMapper.mapList((List)pagination.getDataList(), RepositoryRecent.class);
        this.joinTemplate.joinQuery(repositoryRecentList);
        return PaginationBuilder.build(pagination, (List)repositoryRecentList);
    }

    public void repositoryRecent(RepositoryRecent repositoryRecent) {
        RepositoryRecentQuery repositoryRecentQuery = new RepositoryRecentQuery();
        repositoryRecentQuery.setRepositoryId(repositoryRecent.getRepository().getId());
        repositoryRecentQuery.setUserId(repositoryRecent.getUserId());
        List<RepositoryRecentEntity> repositoryRecentEntityList = this.repositoryRecentDao.findRepositoryRecentList(repositoryRecentQuery);
        List repositoryRecentList = BeanMapper.mapList(repositoryRecentEntityList, RepositoryRecent.class);
        if (CollectionUtils.isNotEmpty((Collection)repositoryRecentList) && repositoryRecentList.size() > 0) {
            RepositoryRecent repositoryRecent1 = (RepositoryRecent)repositoryRecentList.get(0);
            repositoryRecent.setId(repositoryRecent1.getId());
            repositoryRecent.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            this.updateRepositoryRecent(repositoryRecent);
        } else {
            repositoryRecent.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            this.createRepositoryRecent(repositoryRecent);
        }
    }
}

