/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.repository.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.eam.common.context.LoginContext;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.repository.dao.RepositoryFollowDao;
import io.tiklab.teston.repository.entity.RepositoryFollowEntity;
import io.tiklab.teston.repository.model.Repository;
import io.tiklab.teston.repository.model.RepositoryFollow;
import io.tiklab.teston.repository.model.RepositoryFollowQuery;
import io.tiklab.teston.repository.service.RepositoryFollowService;
import io.tiklab.teston.repository.service.RepositoryService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RepositoryFollowServiceImpl
implements RepositoryFollowService {
    @Autowired
    RepositoryFollowDao repositoryFollowDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    RepositoryService repositoryService;

    public String createRepositoryFollow(@NotNull @Valid RepositoryFollow repositoryFollow) {
        String userId = LoginContext.getLoginId();
        RepositoryFollowEntity repositoryFollowEntity = (RepositoryFollowEntity)BeanMapper.map((Object)repositoryFollow, RepositoryFollowEntity.class);
        repositoryFollowEntity.setUserId(userId);
        repositoryFollowEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.repositoryFollowDao.createRepositoryFollow(repositoryFollowEntity);
    }

    public void updateRepositoryFollow(@NotNull @Valid RepositoryFollow repositoryFollow) {
        RepositoryFollowEntity repositoryFollowEntity = (RepositoryFollowEntity)BeanMapper.map((Object)repositoryFollow, RepositoryFollowEntity.class);
        this.repositoryFollowDao.updateRepositoryFollow(repositoryFollowEntity);
    }

    public void deleteRepositoryFollow(@NotNull String id) {
        RepositoryFollowQuery repositoryFollowQuery = new RepositoryFollowQuery();
        repositoryFollowQuery.setUserId(LoginContext.getLoginId());
        List<RepositoryFollowEntity> repositoryFollowEntityList = this.repositoryFollowDao.findRepositoryFollowList(repositoryFollowQuery);
        List repositoryFollowList = BeanMapper.mapList(repositoryFollowEntityList, RepositoryFollow.class);
        this.joinTemplate.joinQuery(repositoryFollowList);
        String followId = null;
        for (RepositoryFollow repositoryFollow : repositoryFollowList) {
            if (!Objects.equals(repositoryFollow.getRepositoryId(), id)) continue;
            followId = repositoryFollow.getId();
        }
        this.repositoryFollowDao.deleteRepositoryFollow(followId);
    }

    public RepositoryFollow findOne(String id) {
        RepositoryFollowEntity repositoryFollowEntity = this.repositoryFollowDao.findRepositoryFollow(id);
        RepositoryFollow repositoryFollow = (RepositoryFollow)BeanMapper.map((Object)repositoryFollowEntity, RepositoryFollow.class);
        return repositoryFollow;
    }

    public List<RepositoryFollow> findList(List<String> idList) {
        List<RepositoryFollowEntity> repositoryFollowEntityList = this.repositoryFollowDao.findRepositoryFollowList(idList);
        List repositoryFollowList = BeanMapper.mapList(repositoryFollowEntityList, RepositoryFollow.class);
        return repositoryFollowList;
    }

    public RepositoryFollow findRepositoryFollow(@NotNull String id) {
        RepositoryFollow repositoryFollow = this.findOne(id);
        this.joinTemplate.joinQuery((Object)repositoryFollow);
        return repositoryFollow;
    }

    public List<RepositoryFollow> findAllRepositoryFollow() {
        List<RepositoryFollowEntity> repositoryFollowEntityList = this.repositoryFollowDao.findAllRepositoryFollow();
        List repositoryFollowList = BeanMapper.mapList(repositoryFollowEntityList, RepositoryFollow.class);
        this.joinTemplate.joinQuery(repositoryFollowList);
        return repositoryFollowList;
    }

    public List<Repository> findRepositoryFollowList(RepositoryFollowQuery repositoryFollowQuery) {
        List<RepositoryFollowEntity> repositoryFollowEntityList = this.repositoryFollowDao.findRepositoryFollowList(repositoryFollowQuery);
        List repositoryFollowList = BeanMapper.mapList(repositoryFollowEntityList, RepositoryFollow.class);
        this.joinTemplate.joinQuery(repositoryFollowList);
        ArrayList<Repository> arrayList = new ArrayList<Repository>();
        for (RepositoryFollow repositoryFollow : repositoryFollowList) {
            Repository repository = this.repositoryService.findRepository(repositoryFollow.getRepositoryId());
            repository.setIsFollow(Integer.valueOf(1));
            arrayList.add(repository);
        }
        return arrayList;
    }

    public Pagination<RepositoryFollow> findRepositoryFollowPage(RepositoryFollowQuery repositoryFollowQuery) {
        Pagination<RepositoryFollowEntity> pagination = this.repositoryFollowDao.findRepositoryFollowPage(repositoryFollowQuery);
        List repositoryFollowList = BeanMapper.mapList((List)pagination.getDataList(), RepositoryFollow.class);
        this.joinTemplate.joinQuery(repositoryFollowList);
        return PaginationBuilder.build(pagination, (List)repositoryFollowList);
    }
}

