/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.repository.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.teston.repository.entity.RepositoryRecentEntity;
import io.tiklab.teston.repository.model.RepositoryRecentQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RepositoryRecentDao {
    private static Logger logger = LoggerFactory.getLogger(RepositoryRecentDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createRepositoryRecent(RepositoryRecentEntity repositoryRecentEntity) {
        return (String)this.jpaTemplate.save((Object)repositoryRecentEntity, String.class);
    }

    public void updateRepositoryRecent(RepositoryRecentEntity repositoryRecentEntity) {
        this.jpaTemplate.update((Object)repositoryRecentEntity);
    }

    public void deleteRepositoryRecent(String id) {
        this.jpaTemplate.delete(RepositoryRecentEntity.class, (Object)id);
    }

    public void deleteRepositoryRecent(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public RepositoryRecentEntity findRepositoryRecent(String id) {
        return (RepositoryRecentEntity)this.jpaTemplate.findOne(RepositoryRecentEntity.class, (Object)id);
    }

    public List<RepositoryRecentEntity> findAllRepositoryRecent() {
        return this.jpaTemplate.findAll(RepositoryRecentEntity.class);
    }

    public List<RepositoryRecentEntity> findRepositoryRecentList(List<String> idList) {
        return this.jpaTemplate.findList(RepositoryRecentEntity.class, idList);
    }

    public List<RepositoryRecentEntity> findRepositoryRecentList(RepositoryRecentQuery repositoryRecentQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(RepositoryRecentEntity.class).eq("repositoryId", (Object)repositoryRecentQuery.getRepositoryId()).eq("userId", (Object)repositoryRecentQuery.getUserId()).orders(repositoryRecentQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, RepositoryRecentEntity.class);
    }

    public Pagination<RepositoryRecentEntity> findRepositoryRecentPage(RepositoryRecentQuery repositoryRecentQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(RepositoryRecentEntity.class).eq("repositoryId", (Object)repositoryRecentQuery.getRepositoryId()).eq("userId", (Object)repositoryRecentQuery.getUserId()).orders(repositoryRecentQuery.getOrderParams()).pagination(repositoryRecentQuery.getPageParam()).get();
        return this.jpaTemplate.findPage((Object)repositoryRecentQuery, RepositoryRecentEntity.class);
    }
}

