/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.repository.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.teston.repository.entity.RepositoryEntity;
import io.tiklab.teston.repository.model.RepositoryQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RepositoryDao {
    private static Logger logger = LoggerFactory.getLogger(RepositoryDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createRepository(RepositoryEntity repositoryEntity) {
        return (String)this.jpaTemplate.save((Object)repositoryEntity, String.class);
    }

    public void updateRepository(RepositoryEntity repositoryEntity) {
        this.jpaTemplate.update((Object)repositoryEntity);
    }

    public void deleteRepository(String id) {
        this.jpaTemplate.delete(RepositoryEntity.class, (Object)id);
    }

    public void deleteRepository(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public RepositoryEntity findRepository(String id) {
        return (RepositoryEntity)this.jpaTemplate.findOne(RepositoryEntity.class, (Object)id);
    }

    public List<RepositoryEntity> findAllRepository() {
        return this.jpaTemplate.findAll(RepositoryEntity.class);
    }

    public List<RepositoryEntity> findRepositoryList(List<String> idList) {
        return this.jpaTemplate.findList(RepositoryEntity.class, idList);
    }

    public List<RepositoryEntity> findRepositoryList(RepositoryQuery repositoryQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(RepositoryEntity.class).eq("userId", (Object)repositoryQuery.getUserId()).like("name", (Object)repositoryQuery.getName()).orders(repositoryQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, RepositoryEntity.class);
    }

    public Pagination<RepositoryEntity> findRepositoryPage(RepositoryQuery repositoryQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(RepositoryEntity.class).eq("userId", (Object)repositoryQuery.getUserId()).like("name", (Object)repositoryQuery.getName()).orders(repositoryQuery.getOrderParams()).pagination(repositoryQuery.getPageParam()).get();
        return this.jpaTemplate.findPage(queryCondition, RepositoryEntity.class);
    }
}

