/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.repository.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.repository.model.Repository;
import io.tiklab.teston.repository.model.RepositoryRecent;
import io.tiklab.teston.repository.model.RepositoryRecentQuery;
import io.tiklab.teston.repository.service.RepositoryRecentService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/repositoryRecent"})
@Api(name="RepositoryRecentController", desc="RepositoryRecentController")
public class RepositoryRecentController {
    private static Logger logger = LoggerFactory.getLogger(RepositoryRecentController.class);
    @Autowired
    private RepositoryRecentService repositoryRecentService;

    @RequestMapping(path={"/findRepositoryRecentList"}, method={RequestMethod.POST})
    @ApiMethod(name="findRepositoryRecentList", desc="\u67e5\u8be2\u6700\u8fd1\u8bbf\u95ee\u4ed3\u5e93\u5217\u8868")
    @ApiParam(name="repositoryRecentQuery", desc="repositoryRecentQuery", required=true)
    public Result<List<Repository>> findRepositoryRecentList(@RequestBody @Valid @NotNull RepositoryRecentQuery repositoryRecentQuery) {
        List repositoryRecentList = this.repositoryRecentService.findRepositoryRecentList(repositoryRecentQuery);
        return Result.ok((Object)repositoryRecentList);
    }

    @RequestMapping(path={"/findRepositoryRecentPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findRepositoryRecentPage", desc="\u6309\u5206\u9875\u67e5\u8be2\u6700\u8fd1\u8bbf\u95ee\u4ed3\u5e93")
    @ApiParam(name="repositoryRecentQuery", desc="repositoryRecentQuery", required=true)
    public Result<Pagination<RepositoryRecent>> findRepositoryRecentPage(@RequestBody @Valid @NotNull RepositoryRecentQuery repositoryRecentQuery) {
        Pagination pagination = this.repositoryRecentService.findRepositoryRecentPage(repositoryRecentQuery);
        return Result.ok((Object)pagination);
    }

    @RequestMapping(path={"/repositoryRecent"}, method={RequestMethod.POST})
    @ApiMethod(name="repositoryRecent", desc="\u8bbe\u7f6e\u6700\u8fd1\u8bbf\u95ee\u4ed3\u5e93")
    @ApiParam(name="repositoryRecent", desc="repositoryRecent", required=true)
    public Result<Void> workspaceRecent(@RequestBody @NotNull @Valid RepositoryRecent repositoryRecent) {
        this.repositoryRecentService.repositoryRecent(repositoryRecent);
        return Result.ok();
    }
}

