/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.repository.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.repository.model.Repository;
import io.tiklab.teston.repository.model.RepositoryFollow;
import io.tiklab.teston.repository.model.RepositoryFollowQuery;
import io.tiklab.teston.repository.service.RepositoryFollowService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/repositoryFollow"})
@Api(name="RepositoryFollowController", desc="\u4ed3\u5e93\u5173\u6ce8\u7ba1\u7406")
public class RepositoryFollowController {
    private static Logger logger = LoggerFactory.getLogger(RepositoryFollowController.class);
    @Autowired
    private RepositoryFollowService repositoryFollowService;

    @RequestMapping(path={"/createRepositoryFollow"}, method={RequestMethod.POST})
    @ApiMethod(name="createRepositoryFollow", desc="\u521b\u5efa\u4ed3\u5e93\u5173\u6ce8")
    @ApiParam(name="repositoryFollow", desc="repositoryFollow", required=true)
    public Result<String> createRepositoryFollow(@RequestBody @NotNull @Valid RepositoryFollow repositoryFollow) {
        String id = this.repositoryFollowService.createRepositoryFollow(repositoryFollow);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateRepositoryFollow"}, method={RequestMethod.POST})
    @ApiMethod(name="updateRepositoryFollow", desc="\u66f4\u65b0\u4ed3\u5e93\u5173\u6ce8")
    @ApiParam(name="repositoryFollow", desc="repositoryFollow", required=true)
    public Result<Void> updateRepositoryFollow(@RequestBody @NotNull @Valid RepositoryFollow repositoryFollow) {
        this.repositoryFollowService.updateRepositoryFollow(repositoryFollow);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteRepositoryFollow"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteRepositoryFollow", desc="\u5220\u9664\u4ed3\u5e93\u5173\u6ce8")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteRepositoryFollow(@NotNull String id) {
        this.repositoryFollowService.deleteRepositoryFollow(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findRepositoryFollow"}, method={RequestMethod.POST})
    @ApiMethod(name="findRepositoryFollow", desc="\u6839\u636eid\u67e5\u627e\u4ed3\u5e93\u5173\u6ce8")
    @ApiParam(name="id", desc="id", required=true)
    public Result<RepositoryFollow> findRepositoryFollow(@NotNull String id) {
        RepositoryFollow repositoryFollow = this.repositoryFollowService.findRepositoryFollow(id);
        return Result.ok((Object)repositoryFollow);
    }

    @RequestMapping(path={"/findAllRepositoryFollow"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllRepositoryFollow", desc="\u67e5\u627e\u6240\u6709\u4ed3\u5e93\u5173\u6ce8")
    public Result<List<RepositoryFollow>> findAllRepositoryFollow() {
        List repositoryFollowList = this.repositoryFollowService.findAllRepositoryFollow();
        return Result.ok((Object)repositoryFollowList);
    }

    @RequestMapping(path={"/findRepositoryFollowList"}, method={RequestMethod.POST})
    @ApiMethod(name="findRepositoryFollowList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2\u4ed3\u5e93\u5173\u6ce8\u5217\u8868")
    @ApiParam(name="repositoryFollowQuery", desc="repositoryFollowQuery", required=true)
    public Result<List<Repository>> findRepositoryFollowList(@RequestBody @Valid @NotNull RepositoryFollowQuery repositoryFollowQuery) {
        List repositoryFollowList = this.repositoryFollowService.findRepositoryFollowList(repositoryFollowQuery);
        return Result.ok((Object)repositoryFollowList);
    }

    @RequestMapping(path={"/findRepositoryFollowPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findRepositoryFollowPage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2\u4ed3\u5e93\u5173\u6ce8")
    @ApiParam(name="repositoryFollowQuery", desc="repositoryFollowQuery", required=true)
    public Result<Pagination<RepositoryFollow>> findRepositoryFollowPage(@RequestBody @Valid @NotNull RepositoryFollowQuery repositoryFollowQuery) {
        Pagination pagination = this.repositoryFollowService.findRepositoryFollowPage(repositoryFollowQuery);
        return Result.ok((Object)pagination);
    }
}

