/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.repository.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.repository.model.Repository;
import io.tiklab.teston.repository.model.RepositoryQuery;
import io.tiklab.teston.repository.service.RepositoryService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/repository"})
@Api(name="RepositoryController", desc="\u4ed3\u5e93\u7ba1\u7406")
public class RepositoryController {
    private static Logger logger = LoggerFactory.getLogger(RepositoryController.class);
    @Autowired
    private RepositoryService repositoryService;

    @RequestMapping(path={"/createRepository"}, method={RequestMethod.POST})
    @ApiMethod(name="createRepository", desc="\u521b\u5efa\u4ed3\u5e93")
    @ApiParam(name="repository", desc="repository", required=true)
    public Result<String> createRepository(@RequestBody @NotNull @Valid Repository repository) {
        String id = this.repositoryService.createRepository(repository);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateRepository"}, method={RequestMethod.POST})
    @ApiMethod(name="updateRepository", desc="\u66f4\u65b0\u4ed3\u5e93")
    @ApiParam(name="repository", desc="repository", required=true)
    public Result<Void> updateRepository(@RequestBody @NotNull @Valid Repository repository) {
        this.repositoryService.updateRepository(repository);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteRepository"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteRepository", desc="\u5220\u9664\u4ed3\u5e93")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteRepository(@NotNull String id) {
        this.repositoryService.deleteRepository(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findRepository"}, method={RequestMethod.POST})
    @ApiMethod(name="findRepository", desc="\u6839\u636eid\u67e5\u627e\u4ed3\u5e93")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Repository> findRepository(@NotNull String id) {
        Repository repository = this.repositoryService.findRepository(id);
        return Result.ok((Object)repository);
    }

    @RequestMapping(path={"/findAllRepository"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllRepository", desc="\u67e5\u627e\u6240\u6709\u4ed3\u5e93")
    public Result<List<Repository>> findAllRepository() {
        List repositoryList = this.repositoryService.findAllRepository();
        return Result.ok((Object)repositoryList);
    }

    @RequestMapping(path={"/findRepositoryList"}, method={RequestMethod.POST})
    @ApiMethod(name="findRepositoryList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2\u4ed3\u5e93\u5217\u8868")
    @ApiParam(name="repositoryQuery", desc="repositoryQuery", required=true)
    public Result<List<Repository>> findRepositoryList(@RequestBody @Valid @NotNull RepositoryQuery repositoryQuery) {
        List repositoryList = this.repositoryService.findRepositoryList(repositoryQuery);
        return Result.ok((Object)repositoryList);
    }

    @RequestMapping(path={"/findRepositoryPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findRepositoryPage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2\u4ed3\u5e93")
    @ApiParam(name="repositoryQuery", desc="repositoryQuery", required=true)
    public Result<Pagination<Repository>> findRepositoryPage(@RequestBody @Valid @NotNull RepositoryQuery repositoryQuery) {
        Pagination pagination = this.repositoryService.findRepositoryPage(repositoryQuery);
        return Result.ok((Object)pagination);
    }

    @RequestMapping(path={"/findRepositoryJoinList"}, method={RequestMethod.POST})
    @ApiMethod(name="findRepositoryJoinList", desc="\u67e5\u8be2\u6211\u52a0\u5165\u7684\u4ed3\u5e93\u5217\u8868")
    @ApiParam(name="repositoryQuery", desc="repositoryQuery", required=true)
    public Result<List<Repository>> findRepositoryJoinList(@RequestBody @Valid @NotNull RepositoryQuery repositoryQuery) {
        List repositoryJoinList = this.repositoryService.findRepositoryJoinList(repositoryQuery);
        return Result.ok((Object)repositoryJoinList);
    }
}

