/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.integrated.teamwire.workItemBind.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.eam.common.context.LoginContext;
import io.tiklab.join.JoinTemplate;
import io.tiklab.rpc.client.router.lookup.FixedLookup;
import io.tiklab.rpc.client.router.lookup.Lookup;
import io.tiklab.teamwire.workitem.model.WorkItem;
import io.tiklab.teamwire.workitem.service.WorkItemService;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrl;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrlQuery;
import io.tiklab.teston.integrated.postin.integratedurl.service.PostinUrlService;
import io.tiklab.teston.integrated.teamwire.workItem.model.WorkItemTestOn;
import io.tiklab.teston.integrated.teamwire.workItemBind.dao.WorkItemBindDao;
import io.tiklab.teston.integrated.teamwire.workItemBind.entity.WorkItemBindEntity;
import io.tiklab.teston.integrated.teamwire.workItemBind.model.WorkItemBind;
import io.tiklab.teston.integrated.teamwire.workItemBind.model.WorkItemBindQuery;
import io.tiklab.teston.integrated.teamwire.workItemBind.service.WorkItemBindService;
import io.tiklab.teston.support.utils.RpcClientApixUtil;
import java.sql.Timestamp;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkItemBindServiceImpl
implements WorkItemBindService {
    @Autowired
    WorkItemBindDao workItemBindDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    RpcClientApixUtil rpcClientApixUtil;
    @Autowired
    PostinUrlService postinUrlService;

    WorkItemService workItemRpc() {
        IntegratedUrlQuery integratedUrlQuery = new IntegratedUrlQuery();
        integratedUrlQuery.setUserId(LoginContext.getLoginId());
        integratedUrlQuery.setProjectName("teamwire");
        List integratedUrlList = this.postinUrlService.findPostinUrlList(integratedUrlQuery);
        return (WorkItemService)this.rpcClientApixUtil.rpcClient().getBean(WorkItemService.class, (Lookup)new FixedLookup(((IntegratedUrl)integratedUrlList.get(0)).getUrl()));
    }

    public String createWorkItemBind(@NotNull @Valid WorkItemBind workItemBind) {
        WorkItemBindEntity workItemBindEntity = (WorkItemBindEntity)BeanMapper.map((Object)workItemBind, WorkItemBindEntity.class);
        workItemBindEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.workItemBindDao.createWorkItemBind(workItemBindEntity);
    }

    public void updateWorkItemBind(@NotNull @Valid WorkItemBind workItemBind) {
        WorkItemBindEntity workItemBindEntity = (WorkItemBindEntity)BeanMapper.map((Object)workItemBind, WorkItemBindEntity.class);
        this.workItemBindDao.updateWorkItemBind(workItemBindEntity);
    }

    public void deleteWorkItemBind(@NotNull String id) {
        this.workItemBindDao.deleteWorkItemBind(id);
    }

    public WorkItemBind findOne(String id) {
        WorkItemBindEntity workItemBindEntity = this.workItemBindDao.findWorkItemBind(id);
        WorkItemBind workItemBind = (WorkItemBind)BeanMapper.map((Object)workItemBindEntity, WorkItemBind.class);
        return workItemBind;
    }

    public List<WorkItemBind> findList(List<String> idList) {
        List<WorkItemBindEntity> workItemBindEntityList = this.workItemBindDao.findWorkItemBindList(idList);
        List workItemBindList = BeanMapper.mapList(workItemBindEntityList, WorkItemBind.class);
        return workItemBindList;
    }

    public WorkItemBind findWorkItemBind(@NotNull String id) {
        WorkItemBind workItemBind = this.findOne(id);
        this.joinTemplate.joinQuery((Object)workItemBind);
        return workItemBind;
    }

    public List<WorkItemBind> findAllWorkItemBind() {
        List<WorkItemBindEntity> workItemBindEntityList = this.workItemBindDao.findAllWorkItemBind();
        List workItemBindList = BeanMapper.mapList(workItemBindEntityList, WorkItemBind.class);
        this.joinTemplate.joinQuery(workItemBindList);
        return workItemBindList;
    }

    public List<WorkItemBind> findWorkItemBindList(WorkItemBindQuery workItemBindQuery) {
        List<WorkItemBindEntity> workItemBindEntityList = this.workItemBindDao.findWorkItemBindList(workItemBindQuery);
        List workItemBindList = BeanMapper.mapList(workItemBindEntityList, WorkItemBind.class);
        if (workItemBindList != null && workItemBindList.size() > 0) {
            for (WorkItemBind workItemBind : workItemBindList) {
                WorkItem workItem = this.workItemRpc().findWorkItem(workItemBind.getWorkItem().getId());
                WorkItemTestOn workItemTestOn = new WorkItemTestOn();
                workItemTestOn.setId(workItem.getId());
                workItemTestOn.setName(workItem.getTitle());
                workItemTestOn.setProjectId(workItem.getProject().getId());
                workItemTestOn.setProjectName(workItem.getProject().getProjectName());
                if (workItem.getWorkStatusNode() != null && workItem.getWorkStatusNode().getName() != null) {
                    workItemTestOn.setStatus(workItem.getWorkStatusNode().getName());
                }
                if (workItem.getAssigner() != null && workItem.getAssigner().getNickname() != null) {
                    workItemTestOn.setDirector(workItem.getAssigner().getNickname());
                }
                if (workItem.getWorkPriority() != null && workItem.getWorkPriority().getName() != null) {
                    workItemTestOn.setPriority(workItem.getWorkPriority().getName());
                }
                workItemBind.setWorkItem(workItemTestOn);
                IntegratedUrlQuery integratedUrlQuery = new IntegratedUrlQuery();
                integratedUrlQuery.setProjectName("teamwire");
                List postinUrlList = this.postinUrlService.findPostinUrlList(integratedUrlQuery);
                workItemBind.setProjectUrl(((IntegratedUrl)postinUrlList.get(0)).getUrl());
            }
        }
        return workItemBindList;
    }

    public Pagination<WorkItemBind> findWorkItemBindPage(WorkItemBindQuery workItemBindQuery) {
        Pagination<WorkItemBindEntity> pagination = this.workItemBindDao.findWorkItemBindPage(workItemBindQuery);
        List workItemBindList = BeanMapper.mapList((List)pagination.getDataList(), WorkItemBind.class);
        this.joinTemplate.joinQuery(workItemBindList);
        return PaginationBuilder.build(pagination, (List)workItemBindList);
    }
}

