/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.integrated.teamwire.workItem.service;

import io.tiklab.eam.common.context.LoginContext;
import io.tiklab.rpc.client.router.lookup.FixedLookup;
import io.tiklab.rpc.client.router.lookup.Lookup;
import io.tiklab.teamwire.project.project.model.Project;
import io.tiklab.teamwire.project.project.service.ProjectService;
import io.tiklab.teamwire.workitem.model.WorkItem;
import io.tiklab.teamwire.workitem.model.WorkItemQuery;
import io.tiklab.teamwire.workitem.model.WorkTypeDm;
import io.tiklab.teamwire.workitem.model.WorkTypeDmQuery;
import io.tiklab.teamwire.workitem.service.WorkItemService;
import io.tiklab.teamwire.workitem.service.WorkTypeDmService;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrl;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrlQuery;
import io.tiklab.teston.integrated.postin.integratedurl.service.PostinUrlService;
import io.tiklab.teston.integrated.teamwire.workItem.model.ProjectTestOn;
import io.tiklab.teston.integrated.teamwire.workItem.model.ProjectTestOnQuery;
import io.tiklab.teston.integrated.teamwire.workItem.model.WorkItemTestOn;
import io.tiklab.teston.integrated.teamwire.workItem.model.WorkItemTestOnQuery;
import io.tiklab.teston.integrated.teamwire.workItem.service.WorkItemTestOnService;
import io.tiklab.teston.integrated.teamwire.workItemBind.model.WorkItemBind;
import io.tiklab.teston.integrated.teamwire.workItemBind.service.WorkItemBindService;
import io.tiklab.teston.support.utils.RpcClientApixUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkItemTestOnServiceImpl
implements WorkItemTestOnService {
    @Autowired
    RpcClientApixUtil rpcClientApixUtil;
    @Autowired
    WorkItemBindService workItemBindService;
    @Autowired
    PostinUrlService postinUrlService;

    ProjectService projectService() {
        IntegratedUrlQuery integratedUrlQuery = new IntegratedUrlQuery();
        integratedUrlQuery.setUserId(LoginContext.getLoginId());
        integratedUrlQuery.setProjectName("teamwire");
        List integratedUrlList = this.postinUrlService.findPostinUrlList(integratedUrlQuery);
        return (ProjectService)this.rpcClientApixUtil.rpcClient().getBean(ProjectService.class, (Lookup)new FixedLookup(((IntegratedUrl)integratedUrlList.get(0)).getUrl()));
    }

    WorkTypeDmService workTypeDmServiceRpc() {
        IntegratedUrlQuery integratedUrlQuery = new IntegratedUrlQuery();
        integratedUrlQuery.setUserId(LoginContext.getLoginId());
        integratedUrlQuery.setProjectName("teamwire");
        List integratedUrlList = this.postinUrlService.findPostinUrlList(integratedUrlQuery);
        return (WorkTypeDmService)this.rpcClientApixUtil.rpcClient().getBean(WorkTypeDmService.class, (Lookup)new FixedLookup(((IntegratedUrl)integratedUrlList.get(0)).getUrl()));
    }

    WorkItemService workItemServiceRpc() {
        IntegratedUrlQuery integratedUrlQuery = new IntegratedUrlQuery();
        integratedUrlQuery.setUserId(LoginContext.getLoginId());
        integratedUrlQuery.setProjectName("teamwire");
        List integratedUrlList = this.postinUrlService.findPostinUrlList(integratedUrlQuery);
        return (WorkItemService)this.rpcClientApixUtil.rpcClient().getBean(WorkItemService.class, (Lookup)new FixedLookup(((IntegratedUrl)integratedUrlList.get(0)).getUrl()));
    }

    public List<ProjectTestOn> findProjectList(ProjectTestOnQuery projectTestOnQuery) {
        List projectList = this.projectService().findAllProject();
        ArrayList<ProjectTestOn> arrayList = new ArrayList<ProjectTestOn>();
        if (projectList != null && projectList.size() > 0) {
            for (Project project : projectList) {
                ProjectTestOn projectTestOn = new ProjectTestOn();
                projectTestOn.setId(project.getId());
                projectTestOn.setName(project.getProjectName());
                arrayList.add(projectTestOn);
            }
        }
        return arrayList;
    }

    public List<WorkItemTestOn> findWorkItemList(WorkItemTestOnQuery workItemTestOnQuery) {
        WorkItemQuery workItemQuery = new WorkItemQuery();
        workItemQuery.setWorkTypeCode(workItemTestOnQuery.getWorkTypeCode());
        workItemQuery.setProjectId(workItemTestOnQuery.getProjectId());
        List workItemList = this.workItemServiceRpc().findWorkItemList(workItemQuery);
        ArrayList<WorkItemTestOn> workItemTestOnList = new ArrayList<WorkItemTestOn>();
        if (workItemList != null && workItemList.size() > 0) {
            for (WorkItem workItem : workItemList) {
                WorkItemTestOn workItemTestOn = new WorkItemTestOn();
                workItemTestOn.setId(workItem.getId());
                workItemTestOn.setName(workItem.getTitle());
                workItemTestOn.setProjectName(workItem.getProject().getProjectName());
                if (workItem.getWorkStatusNode() != null && workItem.getWorkStatusNode().getName() != null) {
                    workItemTestOn.setStatus(workItem.getWorkStatusNode().getName());
                }
                if (workItem.getAssigner() != null && workItem.getAssigner().getNickname() != null) {
                    workItemTestOn.setDirector(workItem.getAssigner().getNickname());
                }
                if (workItem.getWorkPriority() != null && workItem.getWorkPriority().getName() != null) {
                    workItemTestOn.setPriority(workItem.getWorkPriority().getName());
                }
                workItemTestOnList.add(workItemTestOn);
            }
        }
        return workItemTestOnList;
    }

    public WorkItemTestOn findWorkItem(String id) {
        WorkItem workItem = this.workItemServiceRpc().findWorkItem(id);
        WorkItemTestOn workItemTestOn = new WorkItemTestOn();
        workItemTestOn.setId(workItem.getId());
        workItemTestOn.setName(workItem.getTitle());
        workItemTestOn.setProjectId(workItem.getProject().getId());
        workItemTestOn.setProjectName(workItem.getProject().getProjectName());
        if (workItem.getWorkStatusNode() != null && workItem.getWorkStatusNode().getName() != null) {
            workItemTestOn.setStatus(workItem.getWorkStatusNode().getName());
        }
        if (workItem.getAssigner() != null && workItem.getAssigner().getNickname() != null) {
            workItemTestOn.setDirector(workItem.getAssigner().getNickname());
        }
        if (workItem.getWorkPriority() != null && workItem.getWorkPriority().getName() != null) {
            workItemTestOn.setPriority(workItem.getWorkPriority().getName());
        }
        IntegratedUrlQuery integratedUrlQuery = new IntegratedUrlQuery();
        integratedUrlQuery.setProjectName("teamwire");
        List postinUrlList = this.postinUrlService.findPostinUrlList(integratedUrlQuery);
        workItemTestOn.setProjectUrl(((IntegratedUrl)postinUrlList.get(0)).getUrl());
        return workItemTestOn;
    }

    public String createWorkItem(WorkItemTestOn workItemTestOn) {
        WorkTypeDmQuery workTypeDmQuery = new WorkTypeDmQuery();
        workTypeDmQuery.setProjectId(workItemTestOn.getProjectId());
        List workTypeDmList = this.workTypeDmServiceRpc().findWorkTypeDmList(workTypeDmQuery);
        WorkTypeDm defectType = null;
        if (workTypeDmList != null && workTypeDmList.size() > 0) {
            for (WorkTypeDm workTypeDm : workTypeDmList) {
                if (!Objects.equals(workTypeDm.getWorkType().getCode(), "defect")) continue;
                defectType = workTypeDm;
            }
        }
        WorkItem workItem = new WorkItem();
        workItem.setWorkType(defectType);
        Project project = new Project();
        project.setId(workItemTestOn.getProjectId());
        workItem.setProject(project);
        workItem.setTitle(workItemTestOn.getName());
        workItem.setPlanBeginTime(workItemTestOn.getPlanBeginTime());
        workItem.setPlanEndTime(workItemTestOn.getPlanEndTime());
        String defectId = this.workItemServiceRpc().createWorkItem(workItem);
        WorkItemBind workItemBind = new WorkItemBind();
        WorkItemTestOn workItemTestOn1 = new WorkItemTestOn();
        workItemTestOn1.setId(defectId);
        workItemBind.setWorkItem(workItemTestOn1);
        workItemBind.setCaseId(workItemTestOn.getCaseId());
        String workItemBindId = this.workItemBindService.createWorkItemBind(workItemBind);
        return workItemBindId;
    }
}

