/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.integrated.teamwire.workItem.controller;

import io.tiklab.core.Result;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.integrated.teamwire.workItem.model.ProjectTestOn;
import io.tiklab.teston.integrated.teamwire.workItem.model.ProjectTestOnQuery;
import io.tiklab.teston.integrated.teamwire.workItem.model.WorkItemTestOn;
import io.tiklab.teston.integrated.teamwire.workItem.model.WorkItemTestOnQuery;
import io.tiklab.teston.integrated.teamwire.workItem.service.WorkItemTestOnService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/teamWire"})
@Api(name="WorkItemController", desc="postin\u63a5\u53e3\u8f6c\u7528\u4f8b")
public class WorkItemController {
    private static Logger logger = LoggerFactory.getLogger(WorkItemController.class);
    @Autowired
    private WorkItemTestOnService workItemTestOnService;

    @RequestMapping(path={"/createWorkItem"}, method={RequestMethod.POST})
    @ApiMethod(name="createWorkItem", desc="\u521b\u5efa\u7f3a\u9677")
    @ApiParam(name="workItemTestOn", desc="workItemTestOn", required=true)
    public Result<String> createWorkItemBind(@RequestBody @NotNull @Valid WorkItemTestOn workItemTestOn) {
        String id = this.workItemTestOnService.createWorkItem(workItemTestOn);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/findProjectList"}, method={RequestMethod.POST})
    @ApiMethod(name="findProjectList", desc="\u6839\u636e\u67e5\u8be2teamwire \u9879\u76ee\u5217\u8868")
    @ApiParam(name="projectTestOnQuery", desc="projectTestOnQuery")
    public Result<List<ProjectTestOn>> findProjectList(@RequestBody @Valid @NotNull ProjectTestOnQuery projectTestOnQuery) {
        List projectTestOnList = this.workItemTestOnService.findProjectList(projectTestOnQuery);
        return Result.ok((Object)projectTestOnList);
    }

    @RequestMapping(path={"/findWorkItemList"}, method={RequestMethod.POST})
    @ApiMethod(name="findWorkItemList", desc="\u67e5\u8be2teamwire \u9700\u6c42\u7f3a\u9677\u5217\u8868")
    @ApiParam(name="workItemTestOnQuery", desc="workItemTestOnQuery")
    public Result<List<WorkItemTestOn>> findWorkItemList(@RequestBody @Valid @NotNull WorkItemTestOnQuery workItemTestOnQuery) {
        List workItemTestOnList = this.workItemTestOnService.findWorkItemList(workItemTestOnQuery);
        return Result.ok((Object)workItemTestOnList);
    }

    @RequestMapping(path={"/findWorkItem"}, method={RequestMethod.POST})
    @ApiMethod(name="findWorkItem", desc="\u6839\u636eid\u67e5\u627e\u9700\u6c42")
    @ApiParam(name="id", desc="id", required=true)
    public Result<WorkItemTestOn> findCategory(@NotNull String id) {
        WorkItemTestOn workItem = this.workItemTestOnService.findWorkItem(id);
        return Result.ok((Object)workItem);
    }
}

