/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.integrated.postin.workspaceBind.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.eam.common.context.LoginContext;
import io.tiklab.join.JoinTemplate;
import io.tiklab.postin.workspace.model.Workspace;
import io.tiklab.postin.workspace.model.WorkspaceQuery;
import io.tiklab.postin.workspace.service.WorkspaceService;
import io.tiklab.rpc.client.router.lookup.FixedLookup;
import io.tiklab.rpc.client.router.lookup.Lookup;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrl;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrlQuery;
import io.tiklab.teston.integrated.postin.integratedurl.service.PostinUrlService;
import io.tiklab.teston.integrated.postin.workspaceBind.dao.WorkspaceBindDao;
import io.tiklab.teston.integrated.postin.workspaceBind.entity.WorkspaceBindEntity;
import io.tiklab.teston.integrated.postin.workspaceBind.model.WorkspaceBind;
import io.tiklab.teston.integrated.postin.workspaceBind.model.WorkspaceBindQuery;
import io.tiklab.teston.integrated.postin.workspaceBind.service.WorkspaceBindService;
import io.tiklab.teston.support.utils.RpcClientApixUtil;
import java.sql.Timestamp;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkspaceBindServiceImpl
implements WorkspaceBindService {
    @Autowired
    WorkspaceBindDao workspaceBindDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    RpcClientApixUtil rpcClientApixUtil;
    @Autowired
    PostinUrlService postinUrlService;

    WorkspaceService workspaceRpc() {
        IntegratedUrlQuery integratedUrlQuery = new IntegratedUrlQuery();
        integratedUrlQuery.setUserId(LoginContext.getLoginId());
        integratedUrlQuery.setProjectName("postin");
        List integratedUrlList = this.postinUrlService.findPostinUrlList(integratedUrlQuery);
        return (WorkspaceService)this.rpcClientApixUtil.rpcClient().getBean(WorkspaceService.class, (Lookup)new FixedLookup(((IntegratedUrl)integratedUrlList.get(0)).getUrl()));
    }

    public String createWorkspaceBind(@NotNull @Valid WorkspaceBind workspaceBind) {
        WorkspaceBindEntity workspaceBindEntity = (WorkspaceBindEntity)BeanMapper.map((Object)workspaceBind, WorkspaceBindEntity.class);
        workspaceBindEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.workspaceBindDao.createWorkspaceBind(workspaceBindEntity);
    }

    public void updateWorkspaceBind(@NotNull @Valid WorkspaceBind workspaceBind) {
        WorkspaceBindEntity workspaceBindEntity = (WorkspaceBindEntity)BeanMapper.map((Object)workspaceBind, WorkspaceBindEntity.class);
        this.workspaceBindDao.updateWorkspaceBind(workspaceBindEntity);
    }

    public void deleteWorkspaceBind(@NotNull String id) {
        this.workspaceBindDao.deleteWorkspaceBind(id);
    }

    public WorkspaceBind findOne(String id) {
        WorkspaceBindEntity workspaceBindEntity = this.workspaceBindDao.findWorkspaceBind(id);
        WorkspaceBind workspaceBind = (WorkspaceBind)BeanMapper.map((Object)workspaceBindEntity, WorkspaceBind.class);
        return workspaceBind;
    }

    public List<WorkspaceBind> findList(List<String> idList) {
        List<WorkspaceBindEntity> workspaceBindEntityList = this.workspaceBindDao.findWorkspaceBindList(idList);
        List workspaceBindList = BeanMapper.mapList(workspaceBindEntityList, WorkspaceBind.class);
        return workspaceBindList;
    }

    public WorkspaceBind findWorkspaceBind(@NotNull String id) {
        WorkspaceBind workspaceBind = this.findOne(id);
        this.joinTemplate.joinQuery((Object)workspaceBind);
        return workspaceBind;
    }

    public List<WorkspaceBind> findAllWorkspaceBind() {
        List<WorkspaceBindEntity> workspaceBindEntityList = this.workspaceBindDao.findAllWorkspaceBind();
        List workspaceBindList = BeanMapper.mapList(workspaceBindEntityList, WorkspaceBind.class);
        this.joinTemplate.joinQuery(workspaceBindList);
        return workspaceBindList;
    }

    public List<WorkspaceBind> findWorkspaceBindList(WorkspaceBindQuery workspaceBindQuery) {
        List<WorkspaceBindEntity> workspaceBindEntityList = this.workspaceBindDao.findWorkspaceBindList(workspaceBindQuery);
        List workspaceBindList = BeanMapper.mapList(workspaceBindEntityList, WorkspaceBind.class);
        if (workspaceBindList != null && workspaceBindList.size() > 0) {
            for (WorkspaceBind workspaceBind : workspaceBindList) {
                Workspace workspace = this.workspaceRpc().findWorkspace(workspaceBind.getWorkspace().getId());
                workspaceBind.setWorkspace(workspace);
            }
        }
        return workspaceBindList;
    }

    public Pagination<WorkspaceBind> findWorkspaceBindPage(WorkspaceBindQuery workspaceBindQuery) {
        Pagination<WorkspaceBindEntity> pagination = this.workspaceBindDao.findWorkspaceBindPage(workspaceBindQuery);
        List workspaceBindList = BeanMapper.mapList((List)pagination.getDataList(), WorkspaceBind.class);
        this.joinTemplate.joinQuery(workspaceBindList);
        return PaginationBuilder.build(pagination, (List)workspaceBindList);
    }

    public List<Workspace> findWorkspaceList(WorkspaceQuery workspaceQuery) {
        List workspaceList = this.workspaceRpc().findWorkspaceList(workspaceQuery);
        return workspaceList;
    }

    public String bindWorkspace(WorkspaceBind workspaceBind) {
        WorkspaceBindQuery workspaceBindQuery = new WorkspaceBindQuery();
        workspaceBindQuery.setRepositoryId(workspaceBind.getRepositoryId());
        List<WorkspaceBind> workspaceBindList = this.findWorkspaceBindList(workspaceBindQuery);
        if (workspaceBindList != null && workspaceBindList.size() > 0) {
            for (WorkspaceBind workspaceBind1 : workspaceBindList) {
                this.deleteWorkspaceBind(workspaceBind1.getId());
            }
        }
        String workspaceBindId = this.createWorkspaceBind(workspaceBind);
        return workspaceBindId;
    }
}

