/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.integrated.postin.workspaceBind.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.postin.workspace.model.Workspace;
import io.tiklab.postin.workspace.model.WorkspaceQuery;
import io.tiklab.teston.integrated.postin.workspaceBind.model.WorkspaceBind;
import io.tiklab.teston.integrated.postin.workspaceBind.model.WorkspaceBindQuery;
import io.tiklab.teston.integrated.postin.workspaceBind.service.WorkspaceBindService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workspaceBind"})
@Api(name="WorkspaceBindController", desc="\u7ed1\u5b9a\u7684\u7a7a\u95f4\u7ba1\u7406")
public class WorkspaceBindController {
    private static Logger logger = LoggerFactory.getLogger(WorkspaceBindController.class);
    @Autowired
    private WorkspaceBindService workspaceBindService;

    @RequestMapping(path={"/createWorkspaceBind"}, method={RequestMethod.POST})
    @ApiMethod(name="createWorkspaceBind", desc="\u521b\u5efa\u7ed1\u5b9a\u7684\u7a7a\u95f4")
    @ApiParam(name="workspaceBind", desc="workspaceBind", required=true)
    public Result<String> createWorkspaceBind(@RequestBody @NotNull @Valid WorkspaceBind workspaceBind) {
        String id = this.workspaceBindService.createWorkspaceBind(workspaceBind);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateWorkspaceBind"}, method={RequestMethod.POST})
    @ApiMethod(name="updateWorkspaceBind", desc="\u66f4\u65b0\u7ed1\u5b9a\u7684\u7a7a\u95f4")
    @ApiParam(name="workspaceBind", desc="workspaceBind", required=true)
    public Result<Void> updateWorkspaceBind(@RequestBody @NotNull @Valid WorkspaceBind workspaceBind) {
        this.workspaceBindService.updateWorkspaceBind(workspaceBind);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteWorkspaceBind"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteWorkspaceBind", desc="\u5220\u9664\u7ed1\u5b9a\u7684\u7a7a\u95f4")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteWorkspaceBind(@NotNull String id) {
        this.workspaceBindService.deleteWorkspaceBind(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findWorkspaceBind"}, method={RequestMethod.POST})
    @ApiMethod(name="findWorkspaceBind", desc="\u6839\u636eid\u67e5\u627e\u7ed1\u5b9a\u7684\u7a7a\u95f4")
    @ApiParam(name="id", desc="id", required=true)
    public Result<WorkspaceBind> findWorkspaceBind(@NotNull String id) {
        WorkspaceBind workspaceBind = this.workspaceBindService.findWorkspaceBind(id);
        return Result.ok((Object)workspaceBind);
    }

    @RequestMapping(path={"/findAllWorkspaceBind"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllWorkspaceBind", desc="\u67e5\u627e\u6240\u6709\u7ed1\u5b9a\u7684\u7a7a\u95f4")
    public Result<List<WorkspaceBind>> findAllWorkspaceBind() {
        List workspaceBindList = this.workspaceBindService.findAllWorkspaceBind();
        return Result.ok((Object)workspaceBindList);
    }

    @RequestMapping(path={"/findWorkspaceBindList"}, method={RequestMethod.POST})
    @ApiMethod(name="findWorkspaceBindList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2\u7ed1\u5b9a\u7684\u7a7a\u95f4\u5217\u8868")
    @ApiParam(name="workspaceBindQuery", desc="workspaceBindQuery", required=true)
    public Result<List<WorkspaceBind>> findWorkspaceBindList(@RequestBody @Valid @NotNull WorkspaceBindQuery workspaceBindQuery) {
        List workspaceBindList = this.workspaceBindService.findWorkspaceBindList(workspaceBindQuery);
        return Result.ok((Object)workspaceBindList);
    }

    @RequestMapping(path={"/findWorkspaceBindPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findWorkspaceBindPage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2\u7ed1\u5b9a\u7684\u7a7a\u95f4")
    @ApiParam(name="workspaceBindQuery", desc="workspaceBindQuery", required=true)
    public Result<Pagination<WorkspaceBind>> findWorkspaceBindPage(@RequestBody @Valid @NotNull WorkspaceBindQuery workspaceBindQuery) {
        Pagination pagination = this.workspaceBindService.findWorkspaceBindPage(workspaceBindQuery);
        return Result.ok((Object)pagination);
    }

    @RequestMapping(path={"/findWorkspaceList"}, method={RequestMethod.POST})
    @ApiMethod(name="findWorkspaceList", desc="\u67e5\u8be2\u7a7a\u95f4\u5217\u8868")
    @ApiParam(name="workspaceQuery", desc="workspaceQuery", required=true)
    public Result<Workspace> findWorkspaceList(@RequestBody @Valid @NotNull WorkspaceQuery workspaceQuery) {
        List workspaceList = this.workspaceBindService.findWorkspaceList(workspaceQuery);
        return Result.ok((Object)workspaceList);
    }

    @RequestMapping(path={"/bindWorkspace"}, method={RequestMethod.POST})
    @ApiMethod(name="bindWorkspace", desc="\u7ed1\u5b9a\u7a7a\u95f4")
    @ApiParam(name="workspaceBind", desc="workspaceBind", required=true)
    public Result<String> bindWorkspace(@RequestBody @NotNull @Valid WorkspaceBind workspaceBind) {
        String id = this.workspaceBindService.bindWorkspace(workspaceBind);
        return Result.ok((Object)id);
    }
}

