/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.integrated.postin.postinapi.service;

import io.tiklab.core.exception.ApplicationException;
import io.tiklab.eam.common.context.LoginContext;
import io.tiklab.postin.api.apix.model.Apix;
import io.tiklab.postin.api.apix.model.ApixQuery;
import io.tiklab.postin.api.apix.service.ApixService;
import io.tiklab.postin.api.http.definition.model.ApiRequest;
import io.tiklab.postin.api.http.definition.model.FormParam;
import io.tiklab.postin.api.http.definition.model.FormUrlencoded;
import io.tiklab.postin.api.http.definition.model.HttpApi;
import io.tiklab.postin.api.http.definition.model.QueryParam;
import io.tiklab.postin.api.http.definition.model.RawParam;
import io.tiklab.postin.api.http.definition.model.RequestHeader;
import io.tiklab.postin.api.http.definition.service.HttpApiService;
import io.tiklab.rpc.client.router.lookup.FixedLookup;
import io.tiklab.rpc.client.router.lookup.Lookup;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrl;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrlQuery;
import io.tiklab.teston.integrated.postin.integratedurl.service.PostinUrlService;
import io.tiklab.teston.integrated.postin.postinapi.model.PostInApiToCase;
import io.tiklab.teston.integrated.postin.postinapi.service.PostInApiService;
import io.tiklab.teston.integrated.postin.workspaceBind.model.WorkspaceBind;
import io.tiklab.teston.integrated.postin.workspaceBind.model.WorkspaceBindQuery;
import io.tiklab.teston.integrated.postin.workspaceBind.service.WorkspaceBindService;
import io.tiklab.teston.support.utils.RpcClientApixUtil;
import io.tiklab.teston.test.apix.http.unit.cases.model.AfterScript;
import io.tiklab.teston.test.apix.http.unit.cases.model.ApiUnitCase;
import io.tiklab.teston.test.apix.http.unit.cases.model.FormUrlEncoded;
import io.tiklab.teston.test.apix.http.unit.cases.model.PreScript;
import io.tiklab.teston.test.apix.http.unit.cases.model.QueryParams;
import io.tiklab.teston.test.apix.http.unit.cases.model.RequestBody;
import io.tiklab.teston.test.apix.http.unit.cases.service.AfterScriptService;
import io.tiklab.teston.test.apix.http.unit.cases.service.ApiUnitCaseService;
import io.tiklab.teston.test.apix.http.unit.cases.service.FormParamService;
import io.tiklab.teston.test.apix.http.unit.cases.service.FormUrlencodedService;
import io.tiklab.teston.test.apix.http.unit.cases.service.PreScriptService;
import io.tiklab.teston.test.apix.http.unit.cases.service.QueryParamService;
import io.tiklab.teston.test.apix.http.unit.cases.service.RawParamService;
import io.tiklab.teston.test.apix.http.unit.cases.service.RequestBodyService;
import io.tiklab.teston.test.apix.http.unit.cases.service.RequestHeaderService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.service.TestCaseService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostInApiServiceImpl
implements PostInApiService {
    @Autowired
    RpcClientApixUtil rpcClientApixUtil;
    @Autowired
    PostinUrlService postinUrlService;
    @Autowired
    WorkspaceBindService workspaceBindService;
    @Autowired
    RequestHeaderService testOnRequestHeaderService;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    ApiUnitCaseService apiUnitCaseService;
    @Autowired
    QueryParamService testOnQueryService;
    @Autowired
    RequestBodyService testOnRequestBodyService;
    @Autowired
    FormParamService testOndFormParam;
    @Autowired
    FormUrlencodedService testOnFormUrlEncoded;
    @Autowired
    RawParamService testOnRawService;
    @Autowired
    PreScriptService testOnPreScriptService;
    @Autowired
    AfterScriptService testOnAfterScriptService;

    HttpApiService httpApiServiceRpc() {
        IntegratedUrlQuery integratedUrlQuery = new IntegratedUrlQuery();
        integratedUrlQuery.setUserId(LoginContext.getLoginId());
        integratedUrlQuery.setProjectName("postin");
        List integratedUrlList = this.postinUrlService.findPostinUrlList(integratedUrlQuery);
        return (HttpApiService)this.rpcClientApixUtil.rpcClient().getBean(HttpApiService.class, (Lookup)new FixedLookup(((IntegratedUrl)integratedUrlList.get(0)).getUrl()));
    }

    ApixService apixServiceRpc() {
        IntegratedUrlQuery integratedUrlQuery = new IntegratedUrlQuery();
        integratedUrlQuery.setUserId(LoginContext.getLoginId());
        integratedUrlQuery.setProjectName("postin");
        List integratedUrlList = this.postinUrlService.findPostinUrlList(integratedUrlQuery);
        return (ApixService)this.rpcClientApixUtil.rpcClient().getBean(ApixService.class, (Lookup)new FixedLookup(((IntegratedUrl)integratedUrlList.get(0)).getUrl()));
    }

    public List<Apix> findPostInApiList(String repositoryId) {
        WorkspaceBindQuery workspaceBindQuery = new WorkspaceBindQuery();
        workspaceBindQuery.setRepositoryId(repositoryId);
        List workspaceBindList = this.workspaceBindService.findWorkspaceBindList(workspaceBindQuery);
        ArrayList<Apix> apiList = new ArrayList<Apix>();
        if (workspaceBindList != null && workspaceBindList.size() > 0) {
            for (WorkspaceBind workspaceBind : workspaceBindList) {
                ApixQuery apixQuery = new ApixQuery();
                apixQuery.setWorkspaceId(workspaceBind.getWorkspace().getId());
                List apixList = this.apixServiceRpc().findApixList(apixQuery);
                if (apixList == null && apixList.size() == 0) continue;
                for (Apix apix : apixList) {
                    HttpApi httpApi = this.httpApiServiceRpc().findHttpApi(apix.getId());
                    apix.setHttpApi(httpApi);
                }
                apiList.addAll(apixList);
            }
        }
        return apiList;
    }

    public void createPostInApiToCase(PostInApiToCase postInApiToCase) {
        if (postInApiToCase.getApiList() != null) {
            for (String apiId : postInApiToCase.getApiList()) {
                HttpApi httpApi = this.httpApiServiceRpc().findHttpApi(apiId);
                ApiUnitCase apiUnitCase = new ApiUnitCase();
                String apiUnitCaseId = null;
                try {
                    Apix apix = this.apixServiceRpc().findApix(apiId);
                    TestCase testCase = new TestCase();
                    testCase.setName(apix.getName());
                    testCase.setCaseType("api-unit");
                    testCase.setTestType("api");
                    testCase.setDesc(apix.getDesc());
                    testCase.setRepositoryId(postInApiToCase.getRepositoryId());
                    apiUnitCase.setTestCase(testCase);
                    apiUnitCase.setPath(httpApi.getPath());
                    apiUnitCase.setMethodType(httpApi.getMethodType());
                    apiUnitCaseId = this.apiUnitCaseService.createApiUnitCase(apiUnitCase);
                }
                catch (Exception e) {
                    throw new ApplicationException("Error in converting apix to testcase", (Throwable)e);
                }
                if (apiUnitCaseId != null && httpApi.getHeaderList() != null) {
                    this.convertHeader(apiUnitCaseId, httpApi);
                }
                if (apiUnitCaseId != null && httpApi.getQueryList() != null) {
                    this.convertQuery(apiUnitCaseId, httpApi);
                }
                ApiRequest request = httpApi.getRequest();
                if (apiUnitCaseId == null || request == null) continue;
                try {
                    RequestBody testOnRequestBody = new RequestBody();
                    testOnRequestBody.setBodyType(request.getBodyType());
                    testOnRequestBody.setId(apiUnitCaseId);
                    testOnRequestBody.setApiUnitId(apiUnitCaseId);
                    this.testOnRequestBodyService.updateRequestBody(testOnRequestBody);
                }
                catch (Exception e) {
                    throw new ApplicationException("Error in converting request to testcase", (Throwable)e);
                }
                if (request.getBodyType() != null) {
                    switch (request.getBodyType()) {
                        case "formdata": {
                            if (httpApi.getFormList() == null) break;
                            this.convertFormData(apiUnitCaseId, httpApi);
                            break;
                        }
                        case "formUrlencoded": {
                            if (httpApi.getUrlencodedList() == null) break;
                            this.convertFormUrlEncoded(apiUnitCaseId, httpApi);
                            break;
                        }
                        case "raw": {
                            if (httpApi.getRawParam() == null) break;
                            this.convertRaw(apiUnitCaseId, httpApi);
                        }
                    }
                }
                if (request.getAfterScript() != null) {
                    this.convertPreScript(apiUnitCaseId, request);
                }
                if (request.getAfterScript() == null) continue;
                this.convertAfterScript(apiUnitCaseId, request);
            }
        }
    }

    private void convertHeader(String apiUnitCaseId, HttpApi httpApi) {
        try {
            for (RequestHeader postInHeader : httpApi.getHeaderList()) {
                io.tiklab.teston.test.apix.http.unit.cases.model.RequestHeader testOnHeader = new io.tiklab.teston.test.apix.http.unit.cases.model.RequestHeader();
                testOnHeader.setHeaderName(postInHeader.getHeaderName());
                testOnHeader.setRequired(postInHeader.getRequired());
                testOnHeader.setValue(postInHeader.getValue());
                testOnHeader.setDesc(postInHeader.getDesc());
                testOnHeader.setSort(postInHeader.getSort());
                testOnHeader.setApiUnit(new ApiUnitCase().setId(apiUnitCaseId));
                this.testOnRequestHeaderService.createRequestHeader(testOnHeader);
            }
        }
        catch (Exception e) {
            throw new ApplicationException("Error in converting Header", (Throwable)e);
        }
    }

    private void convertQuery(String apiUnitCaseId, HttpApi httpApi) {
        try {
            for (QueryParam postInQuery : httpApi.getQueryList()) {
                QueryParams testOnQuery = new QueryParams();
                testOnQuery.setParamName(postInQuery.getParamName());
                testOnQuery.setValue(postInQuery.getValue());
                testOnQuery.setDesc(postInQuery.getDesc());
                testOnQuery.setSort(postInQuery.getSort());
                testOnQuery.setApiUnit(new ApiUnitCase().setId(apiUnitCaseId));
                this.testOnQueryService.createQueryParam(testOnQuery);
            }
        }
        catch (Exception e) {
            throw new ApplicationException("Error in converting Query", (Throwable)e);
        }
    }

    private void convertFormData(String apiUnitCaseId, HttpApi httpApi) {
        try {
            for (FormParam postInFormParam : httpApi.getFormList()) {
                io.tiklab.teston.test.apix.http.unit.cases.model.FormParam testOnFormParam = new io.tiklab.teston.test.apix.http.unit.cases.model.FormParam();
                testOnFormParam.setParamName(postInFormParam.getParamName());
                testOnFormParam.setValue(postInFormParam.getValue());
                testOnFormParam.setDesc(postInFormParam.getDesc());
                testOnFormParam.setSort(postInFormParam.getSort());
                testOnFormParam.setApiUnit(new ApiUnitCase().setId(apiUnitCaseId));
                this.testOndFormParam.createFormParam(testOnFormParam);
            }
        }
        catch (Exception e) {
            throw new ApplicationException("Error in converting FormData", (Throwable)e);
        }
    }

    private void convertFormUrlEncoded(String apiUnitCaseId, HttpApi httpApi) {
        try {
            for (FormUrlencoded postInFormUrl : httpApi.getUrlencodedList()) {
                FormUrlEncoded testOnFormUrl = new FormUrlEncoded();
                testOnFormUrl.setParamName(postInFormUrl.getParamName());
                testOnFormUrl.setValue(postInFormUrl.getValue());
                testOnFormUrl.setDesc(postInFormUrl.getDesc());
                testOnFormUrl.setSort(postInFormUrl.getSort());
                testOnFormUrl.setApiUnit(new ApiUnitCase().setId(apiUnitCaseId));
                this.testOnFormUrlEncoded.createFormUrlencoded(testOnFormUrl);
            }
        }
        catch (Exception e) {
            throw new ApplicationException("Error in converting FormUrlEncoded", (Throwable)e);
        }
    }

    private void convertRaw(String apiUnitCaseId, HttpApi httpApi) {
        try {
            RawParam postInRaw = httpApi.getRawParam();
            io.tiklab.teston.test.apix.http.unit.cases.model.RawParam testOnRaw = new io.tiklab.teston.test.apix.http.unit.cases.model.RawParam();
            testOnRaw.setRaw(postInRaw.getRaw());
            testOnRaw.setType(postInRaw.getType());
            testOnRaw.setApiUnit(new ApiUnitCase().setId(apiUnitCaseId));
            testOnRaw.setId(apiUnitCaseId);
            this.testOnRawService.createRawParam(testOnRaw);
        }
        catch (Exception e) {
            throw new ApplicationException("Error in converting RawParam", (Throwable)e);
        }
    }

    private void convertPreScript(String apiUnitCaseId, ApiRequest requestData) {
        try {
            String postInPre = requestData.getPreScript();
            PreScript testOnPre = new PreScript();
            testOnPre.setScriptex(postInPre);
            testOnPre.setApiUnit(new ApiUnitCase().setId(apiUnitCaseId));
            testOnPre.setId(apiUnitCaseId);
            this.testOnPreScriptService.createPreScript(testOnPre);
        }
        catch (Exception e) {
            throw new ApplicationException("Error in converting pre script", (Throwable)e);
        }
    }

    private void convertAfterScript(String apiUnitCaseId, ApiRequest requestData) {
        try {
            String postInAfter = requestData.getAfterScript();
            AfterScript testOnAfter = new AfterScript();
            testOnAfter.setScriptex(postInAfter);
            testOnAfter.setApiUnit(new ApiUnitCase().setId(apiUnitCaseId));
            testOnAfter.setId(apiUnitCaseId);
            this.testOnAfterScriptService.createAfterScript(testOnAfter);
        }
        catch (Exception e) {
            throw new ApplicationException("Error in converting after script", (Throwable)e);
        }
    }
}

