/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.integrated.postin.postinapi.controller;

import io.tiklab.core.Result;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.postin.api.apix.model.Apix;
import io.tiklab.teston.integrated.postin.postinapi.model.PostInApiToCase;
import io.tiklab.teston.integrated.postin.postinapi.service.PostInApiService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/postInApi"})
@Api(name="PostInApiController", desc="postin\u63a5\u53e3\u8f6c\u7528\u4f8b")
public class PostInApiController {
    private static Logger logger = LoggerFactory.getLogger(PostInApiController.class);
    @Autowired
    private PostInApiService postInApiService;

    @RequestMapping(path={"/createPostInApiToCase"}, method={RequestMethod.POST})
    @ApiMethod(name="createPostInApiToCase", desc="postin\u63a5\u53e3\u8f6c\u7528\u4f8b")
    @ApiParam(name="postInApiToCase", desc="postInApiToCase", required=true)
    public Result<Void> createPostInApiToCase(@RequestBody @NotNull @Valid PostInApiToCase postInApiToCase) {
        this.postInApiService.createPostInApiToCase(postInApiToCase);
        return Result.ok();
    }

    @RequestMapping(path={"/findPostInApiList"}, method={RequestMethod.POST})
    @ApiMethod(name="findPostInApiList", desc="\u6839\u636e\u67e5\u8be2\u4ed3\u5e93\u5173\u8054\u7684\u7a7a\u95f4\u67e5\u8be2\u63a5\u53e3")
    @ApiParam(name="repositoryId", desc="repositoryId")
    public Result<List<Apix>> findPostInApiList(@NotNull String repositoryId) {
        List postInApiList = this.postInApiService.findPostInApiList(repositoryId);
        return Result.ok((Object)postInApiList);
    }
}

