/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.integrated.postin.integratedurl.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.integrated.postin.integratedurl.dao.PostinUrlDao;
import io.tiklab.teston.integrated.postin.integratedurl.entity.IntegratedUrlEntity;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrl;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrlQuery;
import io.tiklab.teston.integrated.postin.integratedurl.service.PostinUrlService;
import java.sql.Timestamp;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegratedUrlServiceImpl
implements PostinUrlService {
    @Autowired
    PostinUrlDao postinUrlDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createPostinUrl(@NotNull @Valid IntegratedUrl integratedUrl) {
        IntegratedUrlEntity integratedUrlEntity = (IntegratedUrlEntity)BeanMapper.map((Object)integratedUrl, IntegratedUrlEntity.class);
        integratedUrlEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.postinUrlDao.createPostinUrl(integratedUrlEntity);
    }

    public void updatePostinUrl(@NotNull @Valid IntegratedUrl integratedUrl) {
        IntegratedUrlEntity integratedUrlEntity = (IntegratedUrlEntity)BeanMapper.map((Object)integratedUrl, IntegratedUrlEntity.class);
        this.postinUrlDao.updatePostinUrl(integratedUrlEntity);
    }

    public void deletePostinUrl(@NotNull String id) {
        this.postinUrlDao.deletePostinUrl(id);
    }

    public IntegratedUrl findOne(String id) {
        IntegratedUrlEntity integratedUrlEntity = this.postinUrlDao.findPostinUrl(id);
        IntegratedUrl integratedUrl = (IntegratedUrl)BeanMapper.map((Object)integratedUrlEntity, IntegratedUrl.class);
        return integratedUrl;
    }

    public List<IntegratedUrl> findList(List<String> idList) {
        List<IntegratedUrlEntity> integratedUrlEntityList = this.postinUrlDao.findPostinUrlList(idList);
        List integratedUrlList = BeanMapper.mapList(integratedUrlEntityList, IntegratedUrl.class);
        return integratedUrlList;
    }

    public IntegratedUrl findPostinUrl(@NotNull String id) {
        IntegratedUrl integratedUrl = this.findOne(id);
        this.joinTemplate.joinQuery((Object)integratedUrl);
        return integratedUrl;
    }

    public List<IntegratedUrl> findAllPostinUrl() {
        List<IntegratedUrlEntity> integratedUrlEntityList = this.postinUrlDao.findAllPostinUrl();
        List integratedUrlList = BeanMapper.mapList(integratedUrlEntityList, IntegratedUrl.class);
        this.joinTemplate.joinQuery(integratedUrlList);
        return integratedUrlList;
    }

    public List<IntegratedUrl> findPostinUrlList(IntegratedUrlQuery integratedUrlQuery) {
        List<IntegratedUrlEntity> integratedUrlEntityList = this.postinUrlDao.findPostinUrlList(integratedUrlQuery);
        List integratedUrlList = BeanMapper.mapList(integratedUrlEntityList, IntegratedUrl.class);
        this.joinTemplate.joinQuery(integratedUrlList);
        return integratedUrlList;
    }

    public Pagination<IntegratedUrl> findPostinUrlPage(IntegratedUrlQuery integratedUrlQuery) {
        Pagination<IntegratedUrlEntity> pagination = this.postinUrlDao.findPostinUrlPage(integratedUrlQuery);
        List integratedUrlList = BeanMapper.mapList((List)pagination.getDataList(), IntegratedUrl.class);
        this.joinTemplate.joinQuery(integratedUrlList);
        return PaginationBuilder.build(pagination, (List)integratedUrlList);
    }
}

