/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.integrated.postin.integratedurl.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.teston.integrated.postin.integratedurl.entity.IntegratedUrlEntity;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrlQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PostinUrlDao {
    private static Logger logger = LoggerFactory.getLogger(PostinUrlDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createPostinUrl(IntegratedUrlEntity integratedUrlEntity) {
        return (String)this.jpaTemplate.save((Object)integratedUrlEntity, String.class);
    }

    public void updatePostinUrl(IntegratedUrlEntity integratedUrlEntity) {
        this.jpaTemplate.update((Object)integratedUrlEntity);
    }

    public void deletePostinUrl(String id) {
        this.jpaTemplate.delete(IntegratedUrlEntity.class, (Object)id);
    }

    public void deletePostinUrl(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public IntegratedUrlEntity findPostinUrl(String id) {
        return (IntegratedUrlEntity)this.jpaTemplate.findOne(IntegratedUrlEntity.class, (Object)id);
    }

    public List<IntegratedUrlEntity> findAllPostinUrl() {
        return this.jpaTemplate.findAll(IntegratedUrlEntity.class);
    }

    public List<IntegratedUrlEntity> findPostinUrlList(List<String> idList) {
        return this.jpaTemplate.findList(IntegratedUrlEntity.class, idList);
    }

    public List<IntegratedUrlEntity> findPostinUrlList(IntegratedUrlQuery integratedUrlQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(IntegratedUrlEntity.class).eq("userId", (Object)integratedUrlQuery.getUserId()).eq("projectName", (Object)integratedUrlQuery.getProjectName()).orders(integratedUrlQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, IntegratedUrlEntity.class);
    }

    public Pagination<IntegratedUrlEntity> findPostinUrlPage(IntegratedUrlQuery integratedUrlQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(IntegratedUrlEntity.class).eq("userId", (Object)integratedUrlQuery.getUserId()).eq("projectName", (Object)integratedUrlQuery.getProjectName()).orders(integratedUrlQuery.getOrderParams()).pagination(integratedUrlQuery.getPageParam()).get();
        return this.jpaTemplate.findPage(queryCondition, IntegratedUrlEntity.class);
    }
}

