/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.integrated.postin.integratedurl.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrl;
import io.tiklab.teston.integrated.postin.integratedurl.model.IntegratedUrlQuery;
import io.tiklab.teston.integrated.postin.integratedurl.service.PostinUrlService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/postinUrl"})
@Api(name="PostinUrlController", desc="PostinUrl\u914d\u7f6e \u7ba1\u7406")
public class PostinUrlController {
    private static Logger logger = LoggerFactory.getLogger(PostinUrlController.class);
    @Autowired
    private PostinUrlService postinUrlService;

    @RequestMapping(path={"/createPostinUrl"}, method={RequestMethod.POST})
    @ApiMethod(name="createPostinUrl", desc="\u521b\u5efaPostinUrl\u914d\u7f6e")
    @ApiParam(name="integratedUrl", desc="integratedUrl", required=true)
    public Result<String> createPostinUrl(@RequestBody @NotNull @Valid IntegratedUrl integratedUrl) {
        String id = this.postinUrlService.createPostinUrl(integratedUrl);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updatePostinUrl"}, method={RequestMethod.POST})
    @ApiMethod(name="updatePostinUrl", desc="\u66f4\u65b0PostinUrl\u914d\u7f6e")
    @ApiParam(name="integratedUrl", desc="integratedUrl", required=true)
    public Result<Void> updatePostinUrl(@RequestBody @NotNull @Valid IntegratedUrl integratedUrl) {
        this.postinUrlService.updatePostinUrl(integratedUrl);
        return Result.ok();
    }

    @RequestMapping(path={"/deletePostinUrl"}, method={RequestMethod.POST})
    @ApiMethod(name="deletePostinUrl", desc="\u5220\u9664PostinUrl\u914d\u7f6e")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deletePostinUrl(@NotNull String id) {
        this.postinUrlService.deletePostinUrl(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findPostinUrl"}, method={RequestMethod.POST})
    @ApiMethod(name="findPostinUrl", desc="\u6839\u636eid\u67e5\u627ePostinUrl\u914d\u7f6e")
    @ApiParam(name="id", desc="id", required=true)
    public Result<IntegratedUrl> findPostinUrl(@NotNull String id) {
        IntegratedUrl integratedUrl = this.postinUrlService.findPostinUrl(id);
        return Result.ok((Object)integratedUrl);
    }

    @RequestMapping(path={"/findAllPostinUrl"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllPostinUrl", desc="\u67e5\u627e\u6240\u6709PostinUrl\u914d\u7f6e")
    public Result<List<IntegratedUrl>> findAllPostinUrl() {
        List integratedUrlList = this.postinUrlService.findAllPostinUrl();
        return Result.ok((Object)integratedUrlList);
    }

    @RequestMapping(path={"/findPostinUrlList"}, method={RequestMethod.POST})
    @ApiMethod(name="findPostinUrlList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2PostinUrl\u914d\u7f6e\u5217\u8868")
    @ApiParam(name="integratedUrlQuery", desc="integratedUrlQuery", required=true)
    public Result<List<IntegratedUrl>> findPostinUrlList(@RequestBody @Valid @NotNull IntegratedUrlQuery integratedUrlQuery) {
        List integratedUrlList = this.postinUrlService.findPostinUrlList(integratedUrlQuery);
        return Result.ok((Object)integratedUrlList);
    }

    @RequestMapping(path={"/findPostinUrlPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findPostinUrlPage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2PostinUrl\u914d\u7f6e")
    @ApiParam(name="integratedUrlQuery", desc="integratedUrlQuery", required=true)
    public Result<Pagination<IntegratedUrl>> findPostinUrlPage(@RequestBody @Valid @NotNull IntegratedUrlQuery integratedUrlQuery) {
        Pagination pagination = this.postinUrlService.findPostinUrlPage(integratedUrlQuery);
        return Result.ok((Object)pagination);
    }
}

