/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.category.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.category.dao.CategoryDao;
import io.tiklab.teston.category.entity.CategoryEntity;
import io.tiklab.teston.category.model.Category;
import io.tiklab.teston.category.model.CategoryQuery;
import io.tiklab.teston.category.service.CategoryService;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import io.tiklab.teston.test.test.service.TestCaseService;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class CategoryServiceImpl
implements CategoryService {
    @Autowired
    CategoryDao categoryDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    TestCaseService testCaseService;

    public String createCategory(@NotNull @Valid Category category) {
        CategoryEntity categoryEntity = (CategoryEntity)BeanMapper.map((Object)category, CategoryEntity.class);
        return this.categoryDao.createCategory(categoryEntity);
    }

    public void updateCategory(@NotNull @Valid Category category) {
        CategoryEntity categoryEntity = (CategoryEntity)BeanMapper.map((Object)category, CategoryEntity.class);
        this.categoryDao.updateCategory(categoryEntity);
    }

    public void deleteCategory(@NotNull String id) {
        this.testCaseService.deleteTestCaseByCategoryId(id);
        this.categoryDao.deleteCategory(id);
    }

    public Category findOne(String id) {
        CategoryEntity categoryEntity = this.categoryDao.findCategory(id);
        Category category = (Category)BeanMapper.map((Object)categoryEntity, Category.class);
        return category;
    }

    public List<Category> findList(List<String> idList) {
        List<CategoryEntity> categoryEntityList = this.categoryDao.findCategoryList(idList);
        List categoryList = BeanMapper.mapList(categoryEntityList, Category.class);
        return categoryList;
    }

    public Category findCategory(@NotNull String id) {
        Category category = this.findOne(id);
        this.joinTemplate.joinQuery((Object)category);
        return category;
    }

    public List<Category> findAllCategory() {
        List<CategoryEntity> categoryEntityList = this.categoryDao.findAllCategory();
        List categoryList = BeanMapper.mapList(categoryEntityList, Category.class);
        this.joinTemplate.joinQuery(categoryList);
        return categoryList;
    }

    public List<Category> findCategoryList(CategoryQuery categoryQuery) {
        List<CategoryEntity> categoryEntityList = this.categoryDao.findCategoryList(categoryQuery);
        List categoryList = BeanMapper.mapList(categoryEntityList, Category.class);
        this.joinTemplate.joinQuery(categoryList);
        return categoryList;
    }

    public Pagination<Category> findCategoryPage(CategoryQuery categoryQuery) {
        Pagination<CategoryEntity> pagination = this.categoryDao.findCategoryPage(categoryQuery);
        List categoryList = BeanMapper.mapList((List)pagination.getDataList(), Category.class);
        this.joinTemplate.joinQuery(categoryList);
        return PaginationBuilder.build(pagination, (List)categoryList);
    }

    public List<Category> findCategoryListTree(CategoryQuery categoryQuery) {
        List<Category> matchCategoryList = this.findCategoryList(categoryQuery);
        List<Category> categoryMethodList = this.findCategoryMethodList(matchCategoryList, categoryQuery);
        List<Category> topCategoryList = this.findTopCategoryList(categoryMethodList);
        if (topCategoryList != null) {
            for (Category topCategory : topCategoryList) {
                this.setChildren(matchCategoryList, topCategory);
            }
        }
        return topCategoryList;
    }

    public List<Category> findCategoryListTreeTable(CategoryQuery categoryQuery) {
        List<Category> matchCategoryList = this.findCategoryList(categoryQuery);
        List<Category> topCategoryList = this.findTopCategoryList(matchCategoryList);
        if (topCategoryList != null) {
            for (Category topCategory : topCategoryList) {
                this.setChildren(matchCategoryList, topCategory);
            }
        }
        return topCategoryList;
    }

    List<Category> findCategoryMethodList(List<Category> matchCategoryList, CategoryQuery categoryQuery) {
        List<Category> categoryList = matchCategoryList.stream().map(category -> {
            TestCaseQuery testCaseQuery = new TestCaseQuery();
            testCaseQuery.setCategoryId(category.getId());
            testCaseQuery.setCaseType(categoryQuery.getCaseType());
            testCaseQuery.setTestType(categoryQuery.getTestType());
            List testCaseList = this.testCaseService.findTestCaseList(testCaseQuery);
            category.setCaseNum(Integer.valueOf(testCaseList.size()));
            return category;
        }).collect(Collectors.toList());
        return categoryList;
    }

    List<Category> findTopCategoryList(List<Category> matchCategoryList) {
        return matchCategoryList.stream().filter(category -> category.getParentId() == null || ObjectUtils.isEmpty((Object)category.getParentId())).collect(Collectors.toList());
    }

    void setChildren(List<Category> matchCategoryList, Category parentCaegory) {
        List childCategoryList = matchCategoryList.stream().filter(category -> category.getParentId() != null && category.getParentId().equals(parentCaegory.getId())).collect(Collectors.toList());
        if (childCategoryList != null && childCategoryList.size() > 0) {
            parentCaegory.setChildren(childCategoryList);
            for (Category category2 : childCategoryList) {
                this.setChildren(matchCategoryList, category2);
            }
        }
    }
}

