/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.category.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.teston.category.entity.CategoryEntity;
import io.tiklab.teston.category.model.CategoryQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CategoryDao {
    private static Logger logger = LoggerFactory.getLogger(CategoryDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createCategory(CategoryEntity categoryEntity) {
        return (String)this.jpaTemplate.save((Object)categoryEntity, String.class);
    }

    public void updateCategory(CategoryEntity categoryEntity) {
        this.jpaTemplate.update((Object)categoryEntity);
    }

    public void deleteCategory(String id) {
        this.jpaTemplate.delete(CategoryEntity.class, (Object)id);
    }

    public void deleteCategory(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public CategoryEntity findCategory(String id) {
        return (CategoryEntity)this.jpaTemplate.findOne(CategoryEntity.class, (Object)id);
    }

    public List<CategoryEntity> findAllCategory() {
        return this.jpaTemplate.findAll(CategoryEntity.class);
    }

    public List<CategoryEntity> findCategoryList(List<String> idList) {
        return this.jpaTemplate.findList(CategoryEntity.class, idList);
    }

    public List<CategoryEntity> findCategoryList(CategoryQuery categoryQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(CategoryEntity.class).eq("repositoryId", (Object)categoryQuery.getRepositoryId()).like("name", (Object)categoryQuery.getName()).orders(categoryQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, CategoryEntity.class);
    }

    public Pagination<CategoryEntity> findCategoryPage(CategoryQuery categoryQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(CategoryEntity.class).eq("repositoryId", (Object)categoryQuery.getRepositoryId()).like("name", (Object)categoryQuery.getName()).pagination(categoryQuery.getPageParam()).orders(categoryQuery.getOrderParams()).get();
        return this.jpaTemplate.findPage(queryCondition, CategoryEntity.class);
    }
}

