/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.category.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.category.model.Category;
import io.tiklab.teston.category.model.CategoryQuery;
import io.tiklab.teston.category.service.CategoryService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/category"})
@Api(name="CategoryController", desc="\u76ee\u5f55\u7ba1\u7406")
public class CategoryController {
    private static Logger logger = LoggerFactory.getLogger(CategoryController.class);
    @Autowired
    private CategoryService categoryService;

    @RequestMapping(path={"/createCategory"}, method={RequestMethod.POST})
    @ApiMethod(name="createCategory", desc="\u521b\u5efa\u76ee\u5f55")
    @ApiParam(name="category", desc="category", required=true)
    public Result<String> createCategory(@RequestBody @NotNull @Valid Category category) {
        String id = this.categoryService.createCategory(category);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateCategory"}, method={RequestMethod.POST})
    @ApiMethod(name="updateCategory", desc="\u66f4\u65b0\u76ee\u5f55")
    @ApiParam(name="category", desc="category", required=true)
    public Result<Void> updateCategory(@RequestBody @NotNull @Valid Category category) {
        this.categoryService.updateCategory(category);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteCategory"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteCategory", desc="\u5220\u9664\u76ee\u5f55")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteCategory(@NotNull String id) {
        this.categoryService.deleteCategory(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findCategory"}, method={RequestMethod.POST})
    @ApiMethod(name="findCategory", desc="\u6839\u636eid\u67e5\u627e\u76ee\u5f55")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Category> findCategory(@NotNull String id) {
        Category category = this.categoryService.findCategory(id);
        return Result.ok((Object)category);
    }

    @RequestMapping(path={"/findAllCategory"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllCategory", desc="\u67e5\u627e\u6240\u6709\u76ee\u5f55")
    public Result<List<Category>> findAllCategory() {
        List categoryList = this.categoryService.findAllCategory();
        return Result.ok((Object)categoryList);
    }

    @RequestMapping(path={"/findCategoryList"}, method={RequestMethod.POST})
    @ApiMethod(name="findCategoryList", desc="\u67e5\u8be2\u76ee\u5f55\u5217\u8868")
    @ApiParam(name="categoryQuery", desc="categoryQuery", required=true)
    public Result<List<Category>> findCategoryList(@RequestBody @Valid @NotNull CategoryQuery categoryQuery) {
        List categoryList = this.categoryService.findCategoryList(categoryQuery);
        return Result.ok((Object)categoryList);
    }

    @RequestMapping(path={"/findCategoryPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findCategoryPage", desc="\u6309\u5206\u9875\u67e5\u8be2\u76ee\u5f55")
    @ApiParam(name="categoryQuery", desc="categoryQuery", required=true)
    public Result<Pagination<Category>> findCategoryPage(@RequestBody @Valid @NotNull CategoryQuery categoryQuery) {
        Pagination pagination = this.categoryService.findCategoryPage(categoryQuery);
        return Result.ok((Object)pagination);
    }

    @RequestMapping(path={"/findCategoryListTree"}, method={RequestMethod.POST})
    @ApiMethod(name="findCategoryListTree", desc="\u6839\u636e\u67e5\u8be2\u5bf9\u8c61\u67e5\u627e\u5206\u7c7b\u5217\u8868\u6811\uff08\u5e26\u7528\u4f8b\uff09")
    @ApiParam(name="categoryQuery", desc="\u67e5\u8be2\u5bf9\u8c61", required=true)
    public Result<List<Category>> findCategoryListTree(@RequestBody @Valid @NotNull CategoryQuery categoryQuery) {
        List categoryList = this.categoryService.findCategoryListTree(categoryQuery);
        return Result.ok((Object)categoryList);
    }

    @RequestMapping(path={"/findCategoryListTreeTable"}, method={RequestMethod.POST})
    @ApiMethod(name="findCategoryListTreeTable", desc="\u6839\u636e\u67e5\u8be2\u5bf9\u8c61\u67e5\u627e\u5206\u7c7b\u5217\u8868\u6811\uff08\u4e0d\u5e26\u7528\u4f8b\uff09")
    @ApiParam(name="categoryQuery", desc="\u67e5\u8be2\u5bf9\u8c61", required=true)
    public Result<List<Category>> findCategoryListTreeTable(@RequestBody @Valid @NotNull CategoryQuery categoryQuery) {
        List categoryList = this.categoryService.findCategoryListTreeTable(categoryQuery);
        return Result.ok((Object)categoryList);
    }
}

