/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.ejb.remote.runtime;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.wildfly.swarm.config.ejb3.ChannelCreationOptions;
import org.wildfly.swarm.config.security.Flag;
import org.wildfly.swarm.config.security.SecurityDomain;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthentication;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModule;
import org.wildfly.swarm.ejb.EJBFraction;
import org.wildfly.swarm.security.SecurityFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.SwarmProperties;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@ApplicationScoped
public class RemoteServiceCustomizer
implements Customizer {
    @Inject
    @Any
    Instance<EJBFraction> ejbInstance;
    @Inject
    @Any
    Instance<SecurityFraction> secInstance;

    public void customize() {
        if (!this.ejbInstance.isUnsatisfied()) {
            ((EJBFraction)this.ejbInstance.get()).remoteService(remote -> {
                remote.connectorRef("http-remoting-connector");
                remote.threadPoolName("default");
                remote.channelCreationOptions("READ_TIMEOUT", opt -> {
                    opt.value(SwarmProperties.propertyVar((String)"prop.remoting-connector.read.timeout", (String)"20"));
                    opt.type(ChannelCreationOptions.Type.XNIO);
                });
                remote.channelCreationOptions("MAX_OUTBOUND_MESSAGES", opt -> {
                    opt.value("1234");
                    opt.type(ChannelCreationOptions.Type.REMOTING);
                });
            });
            SecurityDomain domain = ((SecurityFraction)this.secInstance.get()).subresources().securityDomain("other");
            if (domain != null) {
                ClassicAuthentication auth = domain.subresources().classicAuthentication();
                List loginModules = auth.subresources().loginModules();
                if (loginModules.stream().noneMatch(lm -> "Remoting".equals(lm.code()))) {
                    loginModules.add(0, new LoginModule("Remoting").code("Remoting").flag(Flag.OPTIONAL).moduleOption("password-stacking", (Object)"useFirstPass"));
                }
            } else {
                throw new IllegalStateException("Expected security domain 'other' to be present!");
            }
        }
    }
}

