/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.quarkus.iam.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.thestencil.iam.api.IAMClient;
import io.thestencil.quarkus.iam.handler.IAMTemplate;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.EncodeException;
import io.vertx.ext.web.RoutingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IAMHandler
extends IAMTemplate {
    private static final Logger log = LoggerFactory.getLogger(IAMHandler.class);
    private final ObjectMapper objectMapper;
    private final String liveness;
    private final String roles;

    public IAMHandler(ObjectMapper objectMapper, CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest, String liveness, String roles) {
        super(currentIdentityAssociation, currentVertxRequest);
        this.liveness = liveness;
        this.roles = roles;
        this.objectMapper = objectMapper;
    }

    @Override
    protected void handleResource(RoutingContext event, HttpServerResponse response, IAMClient ctx) {
        if (event.request().method() != HttpMethod.GET) {
            return;
        }
        String path = event.normalizedPath();
        if (path.startsWith(this.liveness)) {
            ctx.livenessQuery().get().onItem().transform(data -> this.toBuffer(data)).onFailure().invoke(e -> IAMHandler.catch422(e, ctx, response)).subscribe().with(data -> response.end(data));
        } else if (path.startsWith(this.roles)) {
            String id = event.request().getHeader("cookie");
            ctx.userQuery().get().onItem().transformToUni(user -> {
                if (user.getUser().getRepresentedCompany() != null) {
                    return ctx.companyRolesQuery().id(id).get();
                }
                if (user.getUser().getRepresentedPerson() != null) {
                    return ctx.personRolesQuery().id(id).get();
                }
                throw new RuntimeException("Represented person/company could not be resolved!");
            }).onItem().transform(data -> this.toBuffer(data)).onFailure().invoke(e -> IAMHandler.catch422(e, ctx, response)).subscribe().with(data -> response.end(data));
        } else {
            ctx.userQuery().get().onItem().transform(data -> this.toBuffer(data)).onFailure().invoke(e -> IAMHandler.catch422(e, ctx, response)).subscribe().with(data -> response.end(data));
        }
    }

    private Buffer toBuffer(Object object) {
        try {
            log.debug("Responding object: {} body: {}, bodyAsString: {}", new Object[]{object.getClass(), object, this.objectMapper.writeValueAsString(object)});
            return Buffer.buffer((byte[])this.objectMapper.writeValueAsBytes(object));
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }
}

