/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.quarkus.iam.handler;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.thestencil.iam.api.IAMClient;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.enterprise.inject.spi.CDI;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IAMTemplate
implements Handler<RoutingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IAMTemplate.class);
    private final CurrentIdentityAssociation currentIdentityAssociation;
    private final CurrentVertxRequest currentVertxRequest;

    public IAMTemplate(CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest) {
        this.currentIdentityAssociation = currentIdentityAssociation;
        this.currentVertxRequest = currentVertxRequest;
    }

    protected abstract void handleResource(RoutingContext var1, HttpServerResponse var2, IAMClient var3);

    protected void handleSecurity(RoutingContext event) {
        if (this.currentIdentityAssociation != null) {
            QuarkusHttpUser existing = (QuarkusHttpUser)event.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.currentIdentityAssociation.setIdentity(identity);
            } else {
                this.currentIdentityAssociation.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)event, null));
            }
        }
        this.currentVertxRequest.setCurrent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext event) {
        ManagedContext requestContext = Arc.container().requestContext();
        if (requestContext.isActive()) {
            this.handleSecurity(event);
            HttpServerResponse response = event.response();
            IAMClient ctx = (IAMClient)CDI.current().select(IAMClient.class, new Annotation[0]).get();
            try {
                this.handleResource(event, response, ctx);
            }
            catch (Exception e) {
                IAMTemplate.catch422(e, ctx, response);
            }
            return;
        }
        HttpServerResponse response = event.response();
        IAMClient ctx = (IAMClient)CDI.current().select(IAMClient.class, new Annotation[0]).get();
        try {
            requestContext.activate();
            this.handleSecurity(event);
            this.handleResource(event, response, ctx);
        }
        finally {
            requestContext.terminate();
        }
    }

    public static void catch404(String id, IAMClient ctx, HttpServerResponse response) {
        String log = "Token not found with id: " + id;
        String hash = IAMTemplate.exceptionHash(log);
        LOGGER.error(hash + " - " + log);
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("appcode", hash);
        response.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
        response.setStatusCode(404);
        response.end(Json.encode(msg));
    }

    public static void catch422(Throwable e, IAMClient ctx, HttpServerResponse response) {
        String stack = ExceptionUtils.getStackTrace((Throwable)e);
        String log = e.getMessage() + System.lineSeparator() + stack;
        String hash = IAMTemplate.exceptionHash(log);
        LOGGER.error(hash + " - " + log);
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("appcode", hash);
        response.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
        response.setStatusCode(422);
        response.end(Json.encode(msg));
    }

    public static String exceptionHash(String msg) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(msg.getBytes(Charset.forName("UTF-8")));
            byte[] digest = md5.digest();
            return Hex.encodeHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.warn("MD5 Digester not found, falling back to timestamp hash", (Throwable)ex);
            long timestamp = System.currentTimeMillis();
            return Long.toHexString(timestamp);
        }
    }
}

