/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.quarkus.iam;

import io.quarkus.arc.DefaultBean;
import io.thestencil.iam.api.IAMClient;
import io.thestencil.iam.api.ImmutableRemoteIntegration;
import io.thestencil.iam.api.RemoteIntegration;
import io.thestencil.iam.spi.suomi.IAMClientSuomi;
import io.thestencil.quarkus.iam.RuntimeConfig;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.WebClient;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class IAMBeanFactory {
    @Inject
    JsonWebToken idToken;
    private String servicePath;
    private RuntimeConfig runtimeConfig;

    public IAMBeanFactory setServicePath(String servicePath) {
        this.servicePath = servicePath;
        return this;
    }

    public IAMBeanFactory setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
        return this;
    }

    @Produces
    @Singleton
    @DefaultBean
    public IAMClient iamClient(Vertx vertx) {
        WebClient webClient = WebClient.create((Vertx)vertx, (WebClientOptions)new WebClientOptions());
        ImmutableRemoteIntegration personSecurityProxy = ImmutableRemoteIntegration.builder().host(IAMBeanFactory.cleanPath(this.runtimeConfig.personSecurityProxy.host)).path(IAMBeanFactory.cleanPath(this.runtimeConfig.personSecurityProxy.path)).port(this.runtimeConfig.personSecurityProxy.port).protocol(this.runtimeConfig.personSecurityProxy.protocol).build();
        ImmutableRemoteIntegration companySecurityProxy = ImmutableRemoteIntegration.builder().host(IAMBeanFactory.cleanPath(this.runtimeConfig.companySecurityProxy.host)).path(IAMBeanFactory.cleanPath(this.runtimeConfig.companySecurityProxy.path)).port(this.runtimeConfig.companySecurityProxy.port).protocol(this.runtimeConfig.companySecurityProxy.protocol).build();
        return IAMClientSuomi.builder().idToken(this.idToken).servicePath(this.servicePath).personSecurityProxy((RemoteIntegration)personSecurityProxy).companySecurityProxy((RemoteIntegration)companySecurityProxy).webClient(webClient).builder();
    }

    public static String cleanPath(String value) {
        String start = value.startsWith("/") ? value.substring(1) : value;
        return start.endsWith("/") ? value.substring(0, start.length() - 2) : start;
    }
}

