/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.soyuz.topicQueue;

import io.thedocs.soyuz.to;
import io.thedocs.soyuz.topicQueue.TopicConsumerI;
import io.thedocs.soyuz.topicQueue.TopicConsumerOffsetLogic;
import io.thedocs.soyuz.topicQueue.TopicQueueStorageI;
import io.thedocs.soyuz.topicQueue.domain.TopicRecord;
import java.util.List;

public class TopicProcessLogic {
    private TopicQueueStorageI storage;
    private List<TopicConsumerI> consumers;

    public void start() {
        for (TopicConsumerI consumer : this.consumers) {
            to.thread((String)("topic-queue-processor-" + consumer.getConsumerKey()), () -> new ConsumerProcessLogic(this.storage, consumer).start()).start();
        }
    }

    public TopicProcessLogic(TopicQueueStorageI storage, List<TopicConsumerI> consumers) {
        this.storage = storage;
        this.consumers = consumers;
    }

    private static class ConsumerProcessLogic {
        private TopicConsumerOffsetLogic topicConsumerOffsetLogic;
        private TopicConsumerI consumer;

        public ConsumerProcessLogic(TopicQueueStorageI storage, TopicConsumerI consumer) {
            this.consumer = consumer;
            this.topicConsumerOffsetLogic = new TopicConsumerOffsetLogic(storage, consumer.getTopicConsumerKey());
        }

        public void start() {
            while (true) {
                TopicRecord record = this.topicConsumerOffsetLogic.getNextRecordBlocking();
                this.consumer.process(record);
                this.topicConsumerOffsetLogic.markAsProcessed(record);
            }
        }
    }
}

