/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.soyuz.topicQueue;

import io.thedocs.soyuz.topicQueue.TopicQueueStorageI;
import io.thedocs.soyuz.topicQueue.domain.TopicConsumerKey;
import io.thedocs.soyuz.topicQueue.domain.TopicRecord;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class TopicConsumerOffsetLogic {
    private volatile int processedRecordId;
    private TopicConsumerKey topicConsumerKey;
    private TopicQueueStorageI storage;

    public TopicConsumerOffsetLogic(TopicQueueStorageI storage, TopicConsumerKey topicConsumerKey) {
        this.storage = storage;
        this.topicConsumerKey = topicConsumerKey;
        this.processedRecordId = storage.getProcessedRecordId(topicConsumerKey);
    }

    @Nullable
    public TopicRecord getNextRecord() {
        return this.storage.getNextTopicRecord(this.topicConsumerKey, this.processedRecordId);
    }

    public TopicRecord getNextRecordBlocking() {
        while (true) {
            TopicRecord answer;
            if ((answer = this.getNextRecord()) != null) {
                return answer;
            }
            TimeUnit.SECONDS.sleep(1L);
        }
    }

    public void markAsProcessed(TopicRecord record) {
        this.processedRecordId = record.getId();
        this.storage.markRecordAsProcessed(this.topicConsumerKey, record.getId());
    }
}

