/*
 * Decompiled with CFR 0.152.
 */
package io.taktx.client;

import io.taktx.CleanupPolicy;
import io.taktx.client.AnnotationScanner;
import io.taktx.client.DefaultTaktParameterResolverFactory;
import io.taktx.client.ExternalTaskInstanceResponder;
import io.taktx.client.ExternalTaskTriggerConsumer;
import io.taktx.client.ExternalTaskTriggerTopicConsumer;
import io.taktx.client.MessageEventSender;
import io.taktx.client.ProcessDefinitionConsumer;
import io.taktx.client.ProcessDefinitionDeployer;
import io.taktx.client.ProcessInstanceProducer;
import io.taktx.client.ProcessInstanceResponder;
import io.taktx.client.ProcessInstanceUpdateConsumer;
import io.taktx.client.TaktParameterResolverFactory;
import io.taktx.client.UserTaskInstanceResponder;
import io.taktx.client.UserTaskTriggerConsumer;
import io.taktx.client.UserTaskTriggerTopicConsumer;
import io.taktx.client.annotation.TaktDeployment;
import io.taktx.dto.ExternalTaskTriggerDTO;
import io.taktx.dto.InstanceUpdateDTO;
import io.taktx.dto.MessageEventDTO;
import io.taktx.dto.ParsedDefinitionsDTO;
import io.taktx.dto.ProcessDefinitionDTO;
import io.taktx.dto.UserTaskTriggerDTO;
import io.taktx.dto.VariablesDTO;
import io.taktx.topicmanagement.ExternalTaskTopicRequester;
import io.taktx.util.TaktPropertiesHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaktClient {
    private static final Logger log = LoggerFactory.getLogger(TaktClient.class);
    private final ProcessDefinitionConsumer processDefinitionConsumer;
    private final TaktParameterResolverFactory parameterResolverFactory;
    private final ProcessInstanceResponder processInstanceResponder;
    private final Executor executor = Executors.newVirtualThreadPerTaskExecutor();
    private final ProcessDefinitionDeployer processDefinitionDeployer;
    private final ProcessInstanceProducer processInstanceProducer;
    private final ProcessInstanceUpdateConsumer processInstanceUpdateConsumer;
    private final MessageEventSender messageEventSender;
    private final ExternalTaskTriggerTopicConsumer externalTaskTriggerTopicConsumer;
    private final UserTaskTriggerTopicConsumer userTaskTriggerTopicConsumer;
    private final ExternalTaskTopicRequester externalTaskTopicRequester;

    private TaktClient(TaktPropertiesHelper taktPropertiesHelper, ProcessInstanceResponder processInstanceResponder, TaktParameterResolverFactory parameterResolverFactory) {
        this.externalTaskTopicRequester = new ExternalTaskTopicRequester(taktPropertiesHelper);
        this.parameterResolverFactory = parameterResolverFactory;
        this.processDefinitionConsumer = new ProcessDefinitionConsumer(taktPropertiesHelper, this.executor);
        this.processDefinitionDeployer = new ProcessDefinitionDeployer(taktPropertiesHelper);
        this.processInstanceProducer = new ProcessInstanceProducer(taktPropertiesHelper);
        this.messageEventSender = new MessageEventSender(taktPropertiesHelper);
        this.processInstanceUpdateConsumer = new ProcessInstanceUpdateConsumer(taktPropertiesHelper, this.executor);
        this.processInstanceResponder = processInstanceResponder;
        this.externalTaskTriggerTopicConsumer = new ExternalTaskTriggerTopicConsumer(taktPropertiesHelper, this.executor);
        this.userTaskTriggerTopicConsumer = new UserTaskTriggerTopicConsumer(taktPropertiesHelper, this.executor);
    }

    public static TaktClientBuilder newClientBuilder() {
        return new TaktClientBuilder();
    }

    public void start() {
        this.processDefinitionConsumer.subscribeToDefinitionRecords();
    }

    public void stop() {
        this.processDefinitionConsumer.stop();
        if (this.externalTaskTriggerTopicConsumer != null) {
            this.externalTaskTriggerTopicConsumer.stop();
        }
    }

    public String requestExternalTaskTopic(String externalTaskId, int partitions, CleanupPolicy cleanupPolicy) {
        return this.externalTaskTopicRequester.requestExternalTaskTopic(externalTaskId, partitions, cleanupPolicy);
    }

    public ParsedDefinitionsDTO deployProcessDefinition(InputStream inputStream) throws IOException {
        return this.processDefinitionDeployer.deploy(new String(inputStream.readAllBytes()));
    }

    public Optional<ProcessDefinitionDTO> getProcessDefinitionByHash(String processDefinitionId, String hash) {
        return this.processDefinitionConsumer.getDeployedProcessDefinitionbyHash(processDefinitionId, hash);
    }

    public UUID startProcess(String process, VariablesDTO variables) {
        return this.processInstanceProducer.startProcess(process, variables);
    }

    public void sendMessage(MessageEventDTO messageEventDTO) {
        this.messageEventSender.sendMessage(messageEventDTO);
    }

    public void registerInstanceUpdateConsumer(BiConsumer<UUID, InstanceUpdateDTO> consumer) {
        this.processInstanceUpdateConsumer.addInstanceUpdateConsumer(consumer);
    }

    public void deployTaktDeploymentAnnotatedClasses() {
        try {
            Set<TaktDeployment> taktDeployments = AnnotationScanner.findTaktDeployments();
            for (TaktDeployment annotation : taktDeployments) {
                String resource = annotation.resource();
                log.info("Deploying process definition from resource {}", (Object)resource);
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resource);
                if (inputStream == null) {
                    throw new FileNotFoundException("Resource not found: " + resource);
                }
                ParsedDefinitionsDTO parsedDefinitionsDTO = this.deployProcessDefinition(inputStream);
                log.info("Deploying process definition {}", (Object)parsedDefinitionsDTO.getDefinitionsKey());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public ExternalTaskInstanceResponder respondToExternalTask(ExternalTaskTriggerDTO externalTaskTriggerDTO) {
        return this.processInstanceResponder.responderForExternalTaskTrigger(externalTaskTriggerDTO);
    }

    public UserTaskInstanceResponder completeUserTask(UserTaskTriggerDTO userTaskTriggerDTO) {
        return this.processInstanceResponder.responderForUserTaskTrigger(userTaskTriggerDTO);
    }

    public void terminateElementInstance(UUID processInstanceKey) {
        this.processInstanceProducer.terminateProcessInstance(processInstanceKey);
    }

    public void terminateElementInstance(UUID activeProcessInstanceKey, List<Long> elementInstanceIdPath) {
        this.processInstanceProducer.terminateElementInstance(activeProcessInstanceKey, elementInstanceIdPath);
    }

    public void registerExternalTaskConsumer(ExternalTaskTriggerConsumer externalTaskTriggerConsumer) {
        this.externalTaskTriggerTopicConsumer.subscribeToExternalTaskTriggerTopics(externalTaskTriggerConsumer);
    }

    public void registerUserTaskConsumer(UserTaskTriggerConsumer userTaskTriggerConsumer) {
        this.userTaskTriggerTopicConsumer.subscribeToUserTaskTriggerTopics(userTaskTriggerConsumer);
    }

    public ProcessDefinitionConsumer getProcessDefinitionConsumer() {
        return this.processDefinitionConsumer;
    }

    public TaktParameterResolverFactory getParameterResolverFactory() {
        return this.parameterResolverFactory;
    }

    public ProcessInstanceResponder getProcessInstanceResponder() {
        return this.processInstanceResponder;
    }

    public static class TaktClientBuilder {
        private String tenant = System.getenv("TENANT");
        private String namespace = System.getenv("NAMESPACE");
        private Properties kafkaProperties;

        private TaktClientBuilder() {
        }

        public TaktClient build() {
            if (this.tenant == null) {
                throw new IllegalArgumentException("TENANT environment variable is not set");
            }
            if (this.namespace == null) {
                throw new IllegalArgumentException("NAMESPACE environment variable is not set");
            }
            if (this.kafkaProperties == null) {
                throw new IllegalArgumentException("Kakfa properties should be passed");
            }
            TaktPropertiesHelper taktPropertiesHelper = new TaktPropertiesHelper(this.tenant, this.namespace, this.kafkaProperties);
            ProcessInstanceResponder externalTaskResponder = new ProcessInstanceResponder(taktPropertiesHelper);
            DefaultTaktParameterResolverFactory parameterResolverFactory = new DefaultTaktParameterResolverFactory(externalTaskResponder);
            return new TaktClient(taktPropertiesHelper, externalTaskResponder, parameterResolverFactory);
        }

        public TaktClientBuilder withTenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public TaktClientBuilder withNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public TaktClientBuilder withKafkaProperties(Properties kafkaProperties) {
            this.kafkaProperties = kafkaProperties;
            return this;
        }
    }
}

