/*
 * Decompiled with CFR 0.152.
 */
package io.taktx.client;

import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceProvider {
    private static final Logger log = LoggerFactory.getLogger(InstanceProvider.class);
    private static Environment environment;

    public static <T> T getInstance(Class<T> clazz) {
        return switch (environment.ordinal()) {
            case 0 -> InstanceProvider.getQuarkusBean(clazz);
            case 1 -> InstanceProvider.getSpringBean(clazz);
            default -> InstanceProvider.createNewInstance(clazz);
        };
    }

    private static <T> T getQuarkusBean(Class<T> clazz) {
        try {
            log.info("Getting quarkus bean for {}", (Object)clazz.getName());
            return (T)CDI.current().select(clazz, new Annotation[0]).get();
        }
        catch (IllegalStateException e) {
            log.warn("CDI container returning error {} for {}. Creating new instance instead.", (Object)e.getMessage(), (Object)clazz.getName());
            return InstanceProvider.createNewInstance(clazz);
        }
    }

    private static <T> T getSpringBean(Class<T> clazz) {
        try {
            Class<?> contextHolderClass = Class.forName("org.springframework.context.ApplicationContextHolder");
            Object applicationContext = contextHolderClass.getMethod("getApplicationContext", new Class[0]).invoke(null, new Object[0]);
            return clazz.cast(applicationContext.getClass().getMethod("getBean", Class.class).invoke(applicationContext, clazz));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get Spring bean for " + String.valueOf(clazz), e);
        }
    }

    private static <T> T createNewInstance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create a new instance of " + String.valueOf(clazz), e);
        }
    }

    static {
        try {
            Class.forName("io.quarkus.runtime.Quarkus");
            environment = Environment.QUARKUS;
        }
        catch (ClassNotFoundException e1) {
            try {
                Class.forName("org.springframework.context.ApplicationContext");
                environment = Environment.SPRING;
            }
            catch (ClassNotFoundException e2) {
                environment = Environment.PLAIN_JAVA;
            }
        }
    }

    public static enum Environment {
        QUARKUS,
        SPRING,
        PLAIN_JAVA;

    }
}

