/*
 * Decompiled with CFR 0.152.
 */
package io.taktx.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import io.taktx.dto.ContinueFlowElementTriggerDTO;
import io.taktx.dto.ExternalTaskResponseResultDTO;
import io.taktx.dto.ExternalTaskResponseTriggerDTO;
import io.taktx.dto.ExternalTaskResponseType;
import io.taktx.dto.VariablesDTO;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class ExternalTaskInstanceResponder {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new CBORFactory());
    private final KafkaProducer<UUID, ContinueFlowElementTriggerDTO> responseEmitter;
    private final String topicName;
    private final UUID processInstanceKey;
    private final List<Long> elementInstanceIdPath;

    public ExternalTaskInstanceResponder(KafkaProducer<UUID, ContinueFlowElementTriggerDTO> responseEmitter, String topicName, UUID processInstanceKey, List<Long> elementInstanceIdPath) {
        this.responseEmitter = responseEmitter;
        this.topicName = topicName;
        this.processInstanceKey = processInstanceKey;
        this.elementInstanceIdPath = elementInstanceIdPath;
    }

    public void respondSuccess() {
        HashMap<String, JsonNode> variablesMap = new HashMap<String, JsonNode>();
        this.respondSuccess(variablesMap);
    }

    public void respondSuccess(Object variable) {
        Map variablesMap = variable == null ? Map.of() : (Map)OBJECT_MAPPER.convertValue(variable, (TypeReference)new TypeReference<LinkedHashMap<String, JsonNode>>(this){});
        this.respondSuccess(variablesMap);
    }

    public void respondSuccess(Map<String, JsonNode> variablesMap) {
        ExternalTaskResponseResultDTO externalTaskResponseResult = new ExternalTaskResponseResultDTO(ExternalTaskResponseType.SUCCESS, Boolean.valueOf(true), null, null, 0L);
        ExternalTaskResponseTriggerDTO processInstanceTrigger = new ExternalTaskResponseTriggerDTO(this.processInstanceKey, this.elementInstanceIdPath, externalTaskResponseResult, new VariablesDTO(variablesMap));
        this.responseEmitter.send(new ProducerRecord(this.topicName, (Object)processInstanceTrigger.getProcessInstanceKey(), (Object)processInstanceTrigger));
    }

    public void respondEscalation(String code, String message) {
        this.respondEscalation(code, message, VariablesDTO.empty());
    }

    public void respondEscalation(String code, String message, VariablesDTO variables) {
        ExternalTaskResponseTriggerDTO processInstanceTrigger = new ExternalTaskResponseTriggerDTO(this.processInstanceKey, this.elementInstanceIdPath, new ExternalTaskResponseResultDTO(ExternalTaskResponseType.ESCALATION, Boolean.valueOf(true), code, message, 0L), variables);
        this.responseEmitter.send(new ProducerRecord(this.topicName, (Object)processInstanceTrigger.getProcessInstanceKey(), (Object)processInstanceTrigger));
    }

    public void respondError(boolean allowRetry, String code, String message, VariablesDTO variables) {
        ExternalTaskResponseTriggerDTO processInstanceTrigger = new ExternalTaskResponseTriggerDTO(this.processInstanceKey, this.elementInstanceIdPath, new ExternalTaskResponseResultDTO(ExternalTaskResponseType.ERROR, Boolean.valueOf(allowRetry), code, message, 0L), variables);
        this.responseEmitter.send(new ProducerRecord(this.topicName, (Object)processInstanceTrigger.getProcessInstanceKey(), (Object)processInstanceTrigger));
    }

    public void respondError(boolean allowRetry, String code, String message) {
        this.respondError(allowRetry, code, message, VariablesDTO.empty());
    }

    public void respondPromise(Duration duration) {
        ExternalTaskResponseTriggerDTO processInstanceTrigger = new ExternalTaskResponseTriggerDTO(this.processInstanceKey, this.elementInstanceIdPath, new ExternalTaskResponseResultDTO(ExternalTaskResponseType.PROMISE, Boolean.valueOf(true), null, null, duration.toMillis()), VariablesDTO.empty());
        this.responseEmitter.send(new ProducerRecord(this.topicName, (Object)processInstanceTrigger.getProcessInstanceKey(), (Object)processInstanceTrigger));
    }
}

