/*
 * Decompiled with CFR 0.152.
 */
package io.taktx.client;

import io.taktx.client.AnnotationScanner;
import io.taktx.client.ExternalTaskTriggerConsumer;
import io.taktx.client.InstanceProvider;
import io.taktx.client.ProcessInstanceResponder;
import io.taktx.client.TaktParameterResolver;
import io.taktx.client.TaktParameterResolverFactory;
import io.taktx.client.annotation.TaktWorkerMethod;
import io.taktx.dto.ExternalTaskTriggerDTO;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationScanningExternalTaskTriggerConsumer
implements ExternalTaskTriggerConsumer {
    private static final Logger log = LoggerFactory.getLogger(AnnotationScanningExternalTaskTriggerConsumer.class);
    private final Map<String, Method> workerMethods = new HashMap<String, Method>();
    private final Map<String, Object> workerInstances = new HashMap<String, Object>();
    private final TaktParameterResolverFactory parameterResolverFactory;
    private final ProcessInstanceResponder externalTaskResponder;

    public AnnotationScanningExternalTaskTriggerConsumer(TaktParameterResolverFactory parameterResolverFactory, ProcessInstanceResponder externalTaskResponder) {
        this.parameterResolverFactory = parameterResolverFactory;
        this.externalTaskResponder = externalTaskResponder;
        Set<Class<?>> annotatedClasses = AnnotationScanner.findClassesWithAnnotatedMethods(TaktWorkerMethod.class);
        log.info("Found {} classes with @TaktWorkerMethod annotation: {}", (Object)annotatedClasses.size(), (Object)annotatedClasses.stream().map(Class::getName).collect(Collectors.joining(",")));
        for (Class<?> clazz : annotatedClasses) {
            Object instance = InstanceProvider.getInstance(clazz);
            Stream.of(clazz.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(TaktWorkerMethod.class)).forEach(m -> {
                TaktWorkerMethod annotation = m.getAnnotation(TaktWorkerMethod.class);
                String taskId = annotation.taskId();
                this.workerMethods.put(taskId, (Method)m);
                this.workerInstances.put(taskId, instance);
            });
        }
    }

    @Override
    public Set<String> getJobIds() {
        return this.workerMethods.keySet();
    }

    @Override
    public void accept(ExternalTaskTriggerDTO externalTaskTriggerDTO) {
        block8: {
            String taskId = externalTaskTriggerDTO.getExternalTaskId();
            Method method = this.workerMethods.get(taskId);
            Object beanInstance = this.workerInstances.get(taskId);
            if (method == null || beanInstance == null) {
                throw new IllegalStateException("No worker method or bean instance found for task ID: " + taskId);
            }
            TaktWorkerMethod workerMethod = method.getAnnotation(TaktWorkerMethod.class);
            boolean autoComplete = workerMethod.autoComplete();
            Object[] arguments = this.resolveParameters(method, externalTaskTriggerDTO);
            boolean methodIsVoid = method.getReturnType().equals(Void.TYPE);
            if (autoComplete) {
                try {
                    Object result = method.invoke(beanInstance, arguments);
                    if (methodIsVoid) {
                        this.externalTaskResponder.responderForExternalTaskTrigger(externalTaskTriggerDTO).respondSuccess();
                        break block8;
                    }
                    this.externalTaskResponder.responderForExternalTaskTrigger(externalTaskTriggerDTO).respondSuccess(result);
                }
                catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
                    this.externalTaskResponder.responderForExternalTaskTrigger(externalTaskTriggerDTO).respondError(false, "ERROR", e.getMessage());
                }
            } else {
                try {
                    method.invoke(beanInstance, arguments);
                }
                catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
                    this.externalTaskResponder.responderForExternalTaskTrigger(externalTaskTriggerDTO).respondError(false, "ERROR", e.getMessage());
                }
            }
        }
    }

    private Object[] resolveParameters(Method method, ExternalTaskTriggerDTO externalTaskTriggerDTO) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Parameter parameter : method.getParameters()) {
            TaktParameterResolver parameterResolver = this.parameterResolverFactory.create(parameter);
            Object resolved = parameterResolver.resolve(externalTaskTriggerDTO);
            result.add(resolved);
        }
        return result.toArray();
    }
}

