/*
 * Decompiled with CFR 0.152.
 */
package io.taktx.client;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import io.taktx.client.annotation.TaktDeployment;
import java.lang.reflect.Proxy;
import java.util.Set;
import java.util.stream.Collectors;

public class AnnotationScanner {
    private AnnotationScanner() {
    }

    public static Set<Class<?>> findClassesWithAnnotatedMethods(Class<?> annotation) {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().scan();){
            Set<Class<?>> set = scanResult.getClassesWithMethodAnnotation(annotation.getName()).loadClasses().stream().filter(c -> !AnnotationScanner.isProxyClass(c)).collect(Collectors.toSet());
            return set;
        }
    }

    public static Set<TaktDeployment> findTaktDeployments() {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().scan();){
            Set<TaktDeployment> set = scanResult.getClassesWithAnnotation(TaktDeployment.class.getName()).loadClasses().stream().filter(c -> !AnnotationScanner.isProxyClass(c)).map(c -> c.getAnnotation(TaktDeployment.class)).collect(Collectors.toSet());
            return set;
        }
    }

    private static boolean isProxyClass(Class<?> clazz) {
        if (Proxy.isProxyClass(clazz)) {
            return true;
        }
        if (clazz.isSynthetic()) {
            return true;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            String ifaceName = iface.getName();
            if (!ifaceName.contains("EnhancerBySpringCGLIB") && !ifaceName.contains("ByteBuddy") && !ifaceName.contains("javassist") && !ifaceName.contains("$$")) continue;
            return true;
        }
        String className = clazz.getName();
        return className.contains("$$") || className.endsWith("_ClientProxy") || className.endsWith("_Subclass") || className.contains("_HibernateProxy_");
    }
}

