/*
 * Decompiled with CFR 0.152.
 */
package io.taktx.client;

import io.taktx.Topics;
import io.taktx.client.serdes.ProcessInstanceTriggerSerializer;
import io.taktx.dto.ProcessDefinitionKey;
import io.taktx.dto.ProcessInstanceTriggerDTO;
import io.taktx.dto.StartCommandDTO;
import io.taktx.dto.TerminateTriggerDTO;
import io.taktx.dto.VariablesDTO;
import io.taktx.util.TaktPropertiesHelper;
import io.taktx.util.TaktUUIDSerializer;
import java.util.List;
import java.util.UUID;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class ProcessInstanceProducer {
    private final TaktPropertiesHelper kafkaPropertiesHelper;
    private final KafkaProducer<UUID, ProcessInstanceTriggerDTO> processInstanceTriggerEmitter;

    public ProcessInstanceProducer(TaktPropertiesHelper kafkaPropertiesHelper) {
        this.kafkaPropertiesHelper = kafkaPropertiesHelper;
        this.processInstanceTriggerEmitter = new KafkaProducer(kafkaPropertiesHelper.getKafkaProducerProperties(TaktUUIDSerializer.class, ProcessInstanceTriggerSerializer.class));
    }

    public UUID startProcess(String processDefinitionId, VariablesDTO variables) {
        UUID processInstanceKey = UUID.randomUUID();
        StartCommandDTO startCommand = new StartCommandDTO(processInstanceKey, null, null, new ProcessDefinitionKey(processDefinitionId), variables);
        this.processInstanceTriggerEmitter.send(new ProducerRecord(this.kafkaPropertiesHelper.getPrefixedTopicName(Topics.PROCESS_INSTANCE_TRIGGER_TOPIC.getTopicName()), (Object)processInstanceKey, (Object)startCommand));
        return processInstanceKey;
    }

    public void terminateProcessInstance(UUID processInstanceKey) {
        this.terminateElementInstance(processInstanceKey, List.of());
    }

    public void terminateElementInstance(UUID processInstanceKey, List<Long> elementInstanceIdPath) {
        TerminateTriggerDTO terminateTrigger = new TerminateTriggerDTO(processInstanceKey, elementInstanceIdPath);
        this.processInstanceTriggerEmitter.send(new ProducerRecord(this.kafkaPropertiesHelper.getPrefixedTopicName(Topics.PROCESS_INSTANCE_TRIGGER_TOPIC.getTopicName()), (Object)processInstanceKey, (Object)terminateTrigger));
    }
}

