/*
 * Decompiled with CFR 0.152.
 */
package io.taktx.client;

import io.taktx.Topics;
import io.taktx.client.serdes.XmlDefinitionSerializer;
import io.taktx.dto.ParsedDefinitionsDTO;
import io.taktx.dto.XmlDefinitionsDTO;
import io.taktx.util.TaktPropertiesHelper;
import io.taktx.xml.BpmnParser;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionDeployer {
    private static final Logger log = LoggerFactory.getLogger(ProcessDefinitionDeployer.class);
    private final TaktPropertiesHelper taktPropertiesHelper;
    private final KafkaProducer<String, XmlDefinitionsDTO> xmlEmitter;

    ProcessDefinitionDeployer(TaktPropertiesHelper taktPropertiesHelper) {
        this.taktPropertiesHelper = taktPropertiesHelper;
        this.xmlEmitter = new KafkaProducer(taktPropertiesHelper.getKafkaProducerProperties(StringSerializer.class, XmlDefinitionSerializer.class));
    }

    public ParsedDefinitionsDTO deploy(String xml) {
        log.info("Deploying XML {}", (Object)xml);
        ParsedDefinitionsDTO definitions = BpmnParser.parse((String)xml);
        this.xmlEmitter.send(new ProducerRecord(this.taktPropertiesHelper.getPrefixedTopicName(Topics.PROCESS_DEFINITIONS_TRIGGER_TOPIC.getTopicName()), (Object)definitions.getDefinitionsKey().getProcessDefinitionId(), (Object)new XmlDefinitionsDTO(xml)));
        return definitions;
    }
}

