/*
 * Decompiled with CFR 0.152.
 */
package io.taktx.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import io.taktx.client.ExternalTaskInstanceResponder;
import io.taktx.client.ExternalTaskInstanceResponderParameterResolver;
import io.taktx.client.ExternalTaskTriggerDTOParameterResolver;
import io.taktx.client.MapParameterResolver;
import io.taktx.client.ProcessInstanceResponder;
import io.taktx.client.TaktParameterResolver;
import io.taktx.client.TaktParameterResolverFactory;
import io.taktx.client.VariableParameterResolver;
import io.taktx.client.annotation.Variable;
import io.taktx.dto.ExternalTaskTriggerDTO;
import java.lang.reflect.Parameter;
import java.util.Map;

public class DefaultTaktParameterResolverFactory
implements TaktParameterResolverFactory {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new CBORFactory());
    private final ProcessInstanceResponder externalTaskResponder;

    public DefaultTaktParameterResolverFactory(ProcessInstanceResponder externalTaskResponder) {
        this.externalTaskResponder = externalTaskResponder;
    }

    @Override
    public TaktParameterResolver create(Parameter parameter) {
        if (parameter.getType().isAssignableFrom(ExternalTaskTriggerDTO.class)) {
            return new ExternalTaskTriggerDTOParameterResolver();
        }
        if (parameter.getType().isAssignableFrom(ExternalTaskInstanceResponder.class)) {
            return new ExternalTaskInstanceResponderParameterResolver(this.externalTaskResponder);
        }
        if (parameter.getAnnotation(Variable.class) != null) {
            return new VariableParameterResolver(OBJECT_MAPPER, parameter.getType(), parameter.getAnnotation(Variable.class).value());
        }
        if (parameter.getType().isAssignableFrom(Map.class)) {
            return new MapParameterResolver(OBJECT_MAPPER);
        }
        return new VariableParameterResolver(OBJECT_MAPPER, parameter.getType(), parameter.getName());
    }
}

